/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature;

import br.com.esec.icpm.libs.signature.SignatureRequest;
import br.com.esec.icpm.libs.signature.helper.MimeTypeConstants;
import br.com.esec.icpm.libs.signature.helper.RequestBatchSignatureHelper;
import br.com.esec.icpm.libs.signature.response.handler.SignatureBatchAsynchHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureBatchAsynchWithNotifyHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureBatchSynchHandler;
import br.com.esec.icpm.mss.ws.BatchSignatureComplexDocumentRespType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.server.ws.ICPMException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSignatureRequest {
    private static Logger log = LoggerFactory.getLogger(BatchSignatureRequest.class);
    private SignatureRequest request;
    private SignatureStandardType standard = SignatureStandardType.CADES;
    private String message;
    private List<Document> documents = new ArrayList<Document>();

    public BatchSignatureRequest(SignatureRequest request) {
        this.request = request;
    }

    public BatchSignatureRequest cades() {
        this.standard = SignatureStandardType.CADES;
        return this;
    }

    public BatchSignatureRequest xades() {
        this.standard = SignatureStandardType.XADES;
        return this;
    }

    public BatchSignatureRequest adobePdf() {
        this.standard = SignatureStandardType.ADOBEPDF;
        return this;
    }

    public BatchSignatureRequest message(String message) {
        this.message = message;
        return this;
    }

    public BatchSignatureRequest document(String name, InputStream in) {
        this.documents.add(new Document(name, in));
        log.info("Document '" + name + "' added.");
        return this;
    }

    public BatchSignatureRequest document(String name, InputStream in, String mymeType) {
        this.documents.add(new Document(name, in, mymeType));
        log.info("Document '" + name + "' added.");
        return this;
    }

    public SignatureBatchSynchHandler sign() throws ICPMException, IOException {
        log.info("Requesting asynch batch signature to '" + this.request.identifier + "' with standard '" + this.standard + "' and policy type '" + this.request.policyType + "'...");
        BatchSignatureComplexDocumentRespType response = RequestBatchSignatureHelper.requestSynchBatchSignature(this.request.host, this.request.identifier, this.message, this.standard, this.request.policyType, this.request.testMode, this.documents);
        return new SignatureBatchSynchHandler(this.request.host, this.standard, response);
    }

    public SignatureBatchAsynchHandler asynchSign() throws ICPMException, IOException {
        log.info("Requesting asynch batch signature to '" + this.request.identifier + "' with standard '" + this.standard + "' and policy type '" + this.request.policyType + "'...");
        BatchSignatureComplexDocumentRespType response = RequestBatchSignatureHelper.requestAsynchBatchSignature(this.request.host, this.request.identifier, this.message, this.standard, this.request.policyType, this.request.testMode, this.documents);
        return new SignatureBatchAsynchHandler(this.request.host, this.standard, response);
    }

    public SignatureBatchAsynchWithNotifyHandler asynchSignWithNotify() throws ICPMException, IOException {
        log.info("Requesting asynch batch signature to '" + this.request.identifier + "' with standard '" + this.standard + "' and policy type '" + this.request.policyType + "'...");
        BatchSignatureComplexDocumentRespType response = RequestBatchSignatureHelper.requestAsynchWithNotifyBatchSignature(this.request.host, this.request.identifier, this.message, this.standard, this.request.policyType, this.request.testMode, this.documents);
        return new SignatureBatchAsynchWithNotifyHandler(this.request.host, this.standard, response);
    }

    public SignatureBatchAsynchHandler waitTo(long transactionId) throws ICPMException, InterruptedException, TimeoutException {
        return new SignatureBatchAsynchHandler(this.request.host, this.standard, transactionId).waitTo();
    }

    public class Document {
        private final String name;
        private final InputStream in;
        private final String mimeType;

        public Document(String name, InputStream in) {
            this.name = name;
            this.in = in;
            String extension = FilenameUtils.getExtension((String)name);
            this.mimeType = StringUtils.isEmpty((String)extension) ? "application/octet-stream" : MimeTypeConstants.getMimeType(extension.toLowerCase());
            log.info("Document without mimetype. Considering mymetype '" + this.mimeType + "'.");
        }

        public Document(String name, InputStream in, String mimeType) {
            this.name = name;
            this.in = in;
            this.mimeType = mimeType;
        }

        public String getName() {
            return this.name;
        }

        public InputStream getIn() {
            return this.in;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }
}

