/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs.signature;

import br.com.esec.icpm.mss.rest.ApplicationProviderResource;
import br.com.esec.icpm.mss.ws.SignaturePortType;
import br.com.esec.icpm.signer.ws.rest.SslUtils;
import br.com.esec.icpm.signer.ws.soap.CxfUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public class ApWsFactory {
    private static ApWsFactory instance;
    private static final String AP_REST_WS_URL_PATTERN = "%s/mss/restful/";
    private static final String SIGNATURE_SOAP_WS_URL_PATTERN = "%s/mss-ws/SignatureService/SignatureEndpointBean?wsdl";
    private ClientBuilder builder;

    public static ApWsFactory getInstance() {
        if (instance == null) {
            instance = new ApWsFactory();
        }
        return instance;
    }

    private ApWsFactory() {
    }

    public SignaturePortType getSoapService(String host) {
        try {
            URL signatureRequestSoapWsUrl = this.getWsdlUrl(host);
            Service signatureService = Service.create((URL)signatureRequestSoapWsUrl, (QName)SignaturePortType.QNAME);
            SignaturePortType port = (SignaturePortType)signatureService.getPort(SignaturePortType.class);
            CxfUtils.config((Object)port);
            return port;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getWsdlUrl(String host) throws MalformedURLException, URISyntaxException {
        URL signatureRequestSoapWsUrl = new URL(String.format(SIGNATURE_SOAP_WS_URL_PATTERN, host));
        ClientBuilder builder = this.getClientBuilder();
        Response response = null;
        try {
            Client client = builder.build();
            Invocation.Builder request = client.target(signatureRequestSoapWsUrl.toURI()).request();
            response = request.get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                throw new IllegalStateException("Error " + response.getStatus() + " when try download wsdl on url '" + signatureRequestSoapWsUrl + "'.");
            }
            InputStream wsdlDataIn = (InputStream)response.readEntity(InputStream.class);
            File tempFile = File.createTempFile("certillion", ".wsdl");
            FileOutputStream out = new FileOutputStream(tempFile);
            try {
                IOUtils.copy((InputStream)wsdlDataIn, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly((InputStream)wsdlDataIn);
            }
            URL uRL = tempFile.toURI().toURL();
            return uRL;
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public ApplicationProviderResource getRestService(String host) {
        ClientBuilder builder = this.getClientBuilder();
        Client client = builder.build();
        WebTarget target = client.target(String.format(AP_REST_WS_URL_PATTERN, host));
        ResteasyWebTarget rtarget = (ResteasyWebTarget)target;
        ApplicationProviderResource restProxy = (ApplicationProviderResource)rtarget.proxy(ApplicationProviderResource.class);
        return restProxy;
    }

    private ClientBuilder getClientBuilder() {
        if (this.builder == null) {
            this.builder = ClientBuilder.newBuilder();
            SslUtils.config((ClientBuilder)this.builder);
        }
        return this.builder;
    }
}

