package br.com.esec.icpm.libs.signature.response.polling;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;

import br.com.esec.icpm.libs.signature.helper.RequestBatchSignatureHelper;
import br.com.esec.icpm.libs.signature.helper.RequestStatusHelper;
import br.com.esec.icpm.libs.signature.response.Futures;
import br.com.esec.icpm.mss.ws.SignatureStatusRespType;
import br.com.esec.icpm.server.factory.Status;
import br.com.esec.icpm.server.ws.ICPMException;

public class SimplePollingService extends BasePollingService<SignatureStatusRespType> {

	private static Logger log = LoggerFactory.getLogger(RequestBatchSignatureHelper.class);

	private static SimplePollingService instance;

	public static SimplePollingService getInstance() {
		if (instance == null)
			instance = new SimplePollingService();
		return instance;
	}

	public ListenableFuture<SignatureStatusRespType> status(String host, long transactionId) {
		if (Futures.containsKey(host, transactionId)) {
			return Futures.get(host, transactionId);
		}

		SettableFuture<SignatureStatusRespType> future = SettableFuture.create();
		Futures.put(host, transactionId, future);

		final Checker checker = new Checker(host, transactionId);
		schedule(checker);

		return future;
	}

	private class Checker extends BaseChecker {

		public Checker(String host, long transactionId) {
			super(host, transactionId);
		}

		@Override
		protected void check(SettableFuture<SignatureStatusRespType> future) {
			try {
				SignatureStatusRespType signatureStatusResp = RequestStatusHelper.requestStatus(host, transactionId);

				log.info("[TRANSACTION ID " + transactionId + "] Checking simple transaction ...");

				if (signatureStatusResp.getStatus().getStatusCode() == Status.TRANSACTION_IN_PROGRESS.getCode()) {
					schedule(this, counter); // schedule to run again in 2 seconds
					log.info("[TRANSACTION ID " + transactionId + "] In progess yet. A next check was scheduled.");
				} else {
					future.set(signatureStatusResp);
				}
			} catch (ICPMException e) {
				future.setException(e);
			}
		}

	}

	private SimplePollingService() {
	}
}
