package br.com.esec.icpm.libs.signature.response.polling;

import java.util.concurrent.TimeUnit;

import com.google.common.util.concurrent.SettableFuture;

import br.com.esec.icpm.libs.signature.response.Futures;
import br.com.esec.icpm.libs.signature.response.ThreadPool;

public abstract class BasePollingService<T> {

	protected final int WAIT_TIME = 2 * 1000; // 2s
	protected final int MULTIPLIER_FACTOR_WAIT_TIME = 2;

	protected void schedule(final BaseChecker checker) {
		schedule(checker, 0);
	}

	protected void schedule(final BaseChecker checker, int tries) {
		final int waitTime = WAIT_TIME + (WAIT_TIME * (MULTIPLIER_FACTOR_WAIT_TIME * (tries / 25)));
		ThreadPool.instance.schedule(checker, waitTime, TimeUnit.MILLISECONDS);
	}

	protected abstract class BaseChecker implements Runnable {

		protected static final int MAX_EXECUTIONS = 1000;

		protected String host;
		protected long transactionId;

		protected int counter = 0;

		public BaseChecker(String host, long transactionId) {
			this.host = host;
			this.transactionId = transactionId;
		}

		@SuppressWarnings("unchecked")
		@Override
		public void run() {
			SettableFuture<T> future = (SettableFuture<T>) Futures.get(host, transactionId);

			// No one waiting for it
			if (future == null || future.isDone() || future.isCancelled()) {
				Futures.remove(host, transactionId);
				return;
			}

			//
			if (counter == MAX_EXECUTIONS) {
				Futures.remove(host, transactionId);
				return;
			}

			check(future);

			counter++;
		}

		protected abstract void check(SettableFuture<T> future);
	}
}
