package br.com.esec.icpm.libs.signature.response.notify;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;

import br.com.esec.icpm.libs.signature.response.Futures;
import br.com.esec.icpm.mss.ws.notification.BatchSignatureNotificationType;
import br.com.esec.icpm.mss.ws.notification.SignatureNotificationType;

public class SignatureNotifier {
	
	private static Logger log = LoggerFactory.getLogger(SignatureNotifier.class);
	
	private String host;

	public SignatureNotifier(String host) {
		this.host = host;
	}

	public void simple(SignatureNotificationType notify) {
		log.info("Notificatifying batch signature  of transaction " + notify.getTransactionId() + "...");
		
		Long transactionId = notify.getTransactionId();
		ListenableFuture<SignatureNotificationType> future = Futures.get(host, transactionId);
		((SettableFuture<SignatureNotificationType>) future).set(notify);
		
		Futures.remove(host, transactionId);
	}

	public void batch(BatchSignatureNotificationType notify) {
		log.info("Notificatifying batch signature  of transaction " + notify.getTransactionId() + "...");
		
		Long transactionId = notify.getTransactionId();
		ListenableFuture<BatchSignatureNotificationType> future = Futures.get(host, transactionId);
		((SettableFuture<BatchSignatureNotificationType>) future).set(notify);
		
		Futures.remove(host, transactionId);
	}

}
