package br.com.esec.icpm.libs.signature.response.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import br.com.esec.icpm.libs.signature.exceptions.SignatureException;
import br.com.esec.icpm.mss.ws.SignatureRespType;

public class SignatureSimpleSynchHandler extends BaseSignatureHandler {

	private InputStream signature;
	private int statusCode;
	private String statusMessage;

	public SignatureSimpleSynchHandler(String host, SignatureRespType response) {
		super(host, response.getTransactionId());

		try {
			if (response.getStatus() != null) {
				statusCode = response.getStatus().getStatusCode();
				statusMessage = response.getStatus().getStatusMessage();
				signature = parseSignature(statusCode, response.getSignature());
			}
		} catch (IOException e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public SignatureHandler save(OutputStream out) throws IOException, SignatureException {
		validateStatus(transactionId, statusCode, statusMessage);
		
		saveCades(out, signature);
		
		return this;
	}

	@Override
	public SignatureHandler save(InputStream in, OutputStream out) throws IOException, SignatureException {
		validateStatus(transactionId, statusCode, statusMessage);
		
		saveCades(in, out, signature);
		
		return this;
	}

}
