package br.com.esec.icpm.libs.signature.response.handler;

import java.util.Deque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import br.com.esec.icpm.libs.signature.response.polling.BatchPollingService;
import br.com.esec.icpm.mss.ws.BatchSignatureTIDsRespType;
import br.com.esec.icpm.mss.ws.SignatureStandardType;
import br.com.esec.icpm.server.ws.ICPMException;

public abstract class BaseBatchAsynchSignatureHandler extends BaseBatchSignatureHandler implements SignatureAsynchHandler {

	public BaseBatchAsynchSignatureHandler(String host, SignatureStandardType standard, long transactionId) {
		super(host, standard, transactionId);
	}

	public SignatureInfos waitForDocInfos() throws ICPMException, InterruptedException, TimeoutException {
		return waitForDocInfos(DEFAULT_TIMEOUT);
	}

	public SignatureInfos waitForDocInfos(long timeout) throws ICPMException, InterruptedException, TimeoutException {
		Future<BatchSignatureTIDsRespType> result = BatchPollingService.getInstance().status(host, transactionId, true);
		try {
			BatchSignatureTIDsRespType signatureStatusResp = result.get(timeout, TimeUnit.SECONDS);
			documentsStatus = parseDocumentStatus(signatureStatusResp.getDocumentSignatureStatus());
		} catch (TimeoutException e) {
			result.cancel(true);
			throw e;
		} catch (ExecutionException e) {
			throw new IllegalStateException(e);
		}

		return new SignatureInfos(transactionId, documentsStatus);
	}
	

	public class SignatureInfos {

		private final long transactionId;
		private final Deque<DocumentStatus> documentsStatus;

		public SignatureInfos(long transactionId, Deque<DocumentStatus> documentsStatus) {
			this.transactionId = transactionId;
			this.documentsStatus = documentsStatus;
		}

		public long getTransactionId() {
			return transactionId;
		}

		public Deque<DocumentStatus> getDocumentsStatus() {
			return documentsStatus;
		}

	}
}
