package br.com.esec.icpm.libs.signature.response;

import java.util.HashMap;
import java.util.Map;

import com.google.common.util.concurrent.ListenableFuture;

@SuppressWarnings("unchecked")
public final class Futures<V> {

	private static Map<HostAndTransactionKey, ListenableFuture<?>> values = new HashMap<HostAndTransactionKey, ListenableFuture<?>>();

	public static void put(String host, Long transactionId, ListenableFuture<?> value) {
		values.put(new HostAndTransactionKey(host, transactionId), value);
	}

	public static <V> ListenableFuture<V> get(String host, Long transactionId) {
		return (ListenableFuture<V>) values.get(new HostAndTransactionKey(host, transactionId));
	}

	public static <V> ListenableFuture<V> remove(String host, long transactionId) {
		return (ListenableFuture<V>) values.remove(new HostAndTransactionKey(host, transactionId));
	}

	public static boolean containsKey(String host, long transactionId) {
		return values.containsKey(new HostAndTransactionKey(host, transactionId));
	}

	static class HostAndTransactionKey {
		String host;
		Long transactionId;

		public HostAndTransactionKey(String host, Long transactionId) {
			this.host = host;
			this.transactionId = transactionId;
		}

		@Override
		public String toString() {
			return "HostAndTransactionKey [host=" + host + ", transactionId=" + transactionId + "]";
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + ((host == null) ? 0 : host.hashCode());
			result = prime * result + ((transactionId == null) ? 0 : transactionId.hashCode());
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			HostAndTransactionKey other = (HostAndTransactionKey) obj;
			if (host == null) {
				if (other.host != null)
					return false;
			} else if (!host.equals(other.host))
				return false;
			if (transactionId == null) {
				if (other.transactionId != null)
					return false;
			} else if (!transactionId.equals(other.transactionId))
				return false;
			return true;
		}

	}

}
