package br.com.esec.icpm.libs.signature;

import java.io.IOException;
import java.util.concurrent.TimeoutException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import br.com.esec.icpm.libs.signature.helper.RequestSimpleSignatureHelper;
import br.com.esec.icpm.libs.signature.response.handler.SignatureSimpleAsynchHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureSimpleAsynchWithNotifyHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureSimpleSynchHandler;
import br.com.esec.icpm.mss.ws.SignatureRespType;
import br.com.esec.icpm.server.ws.ICPMException;

public class SimpleSignatureRequest {

	private static Logger log = LoggerFactory.getLogger(SimpleSignatureRequest.class);

	private SignatureRequest request;

	private String message;
	
	public SimpleSignatureRequest(SignatureRequest request) {
		this.request = request;
	}
	
	public SimpleSignatureRequest message(String message) {
		this.message = message;
		return this;
	}
	
	public SignatureSimpleSynchHandler sign() throws ICPMException, IOException {
		log.info("Requesting asynch batch signature to '" + request.identifier + "'.");
		SignatureRespType response = RequestSimpleSignatureHelper.requestSynchSimpleSignature(request.host, request.identifier, message, request.policyType, request.testMode);
		
		return new SignatureSimpleSynchHandler(request.host, response);
	}

	public SignatureSimpleAsynchHandler asynchSign() throws ICPMException, IOException {
		log.info("Requesting asynch batch signature to '" + request.identifier + "'.");
		SignatureRespType response = RequestSimpleSignatureHelper.requestAsynchSimpleSignature(request.host, request.identifier, message, request.policyType, request.testMode);
		
		return new SignatureSimpleAsynchHandler(request.host, response);
	}

	public SignatureSimpleAsynchWithNotifyHandler asynchSignWithNotify() throws ICPMException, IOException {
		log.info("Requesting asynch batch signature to '" + request.identifier + "'.");
		SignatureRespType response = RequestSimpleSignatureHelper.requestAsynchWithNotifySimpleSignature(request.host, request.identifier, message, request.policyType, request.testMode);

		return new SignatureSimpleAsynchWithNotifyHandler(request.host, response);
	}

	public SignatureSimpleAsynchHandler waitFor(long transactionId) throws ICPMException, InterruptedException, TimeoutException {
		return new SignatureSimpleAsynchHandler(request.host, transactionId).waitTo();
	}
}
