package br.com.esec.icpm.libs.signature;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import br.com.esec.icpm.server.ws.SignaturePolicyType;

public class SignatureRequest {

	private static Logger log = LoggerFactory.getLogger(SignatureRequest.class);
	
	String identifier;
	boolean testMode;
	SignaturePolicyType policyType = SignaturePolicyType.AD_RB;
	String host;

	public SignatureRequest(String host) {
		this.host = host;
	}
	
	public SignatureRequest testMode() {
		testMode = true;
		return this;
	}

	public SignatureRequest toUser(String identifier) {
		this.identifier = identifier;
		return this;
	}
	
	public SimpleSignatureRequest simple() {
		return new SimpleSignatureRequest(this);
	}
	
	public BatchSignatureRequest batch() {
		return new BatchSignatureRequest(this);
	}

	public SignatureRequest adRb() {
		policyType = SignaturePolicyType.AD_RB;
		return this;
	}

	public SignatureRequest adRt() {
		policyType = SignaturePolicyType.AD_RT;
		return this;
	}

	public SignatureRequest adRc() {
		policyType = SignaturePolicyType.AD_RC;
		return this;
	}

	public SignatureRequest adRv() {
		policyType = SignaturePolicyType.AD_RV;
		return this;
	}

	public SignatureRequest adRa() {
		policyType = SignaturePolicyType.AD_RA;
		return this;
	}

	public SignatureRequest useHost(String host) {
		this.host = host;
		return this;
	}
}
