package br.com.esec.icpm.libs.signature;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation.Builder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.xml.ws.Service;

import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

import br.com.esec.icpm.mss.rest.ApplicationProviderResource;
import br.com.esec.icpm.mss.ws.SignaturePortType;
import br.com.esec.icpm.signer.ws.rest.SslUtils;
import br.com.esec.icpm.signer.ws.soap.CxfUtils;

public class ApWsFactory {

	private static ApWsFactory instance;

	private static final String AP_REST_WS_URL_PATTERN = "%s/mss/restful/";
	private static final String SIGNATURE_SOAP_WS_URL_PATTERN = "%s/mss-ws/SignatureService/SignatureEndpointBean?wsdl";

	public static ApWsFactory getInstance() {
		if (instance == null)
			instance = new ApWsFactory();
		return instance;
	}

	private ApWsFactory() {
	}

	public SignaturePortType getSoapService(String host) {
		try {
			URL signatureRequestSoapWsUrl = getWsdlUrl(host);
			Service signatureService = Service.create(signatureRequestSoapWsUrl, SignaturePortType.QNAME);
			final SignaturePortType port = signatureService.getPort(SignaturePortType.class);

			CxfUtils.config(port);

			return port;
		} catch (MalformedURLException e) {
			throw new IllegalStateException(e);
		} catch (URISyntaxException e) {
			throw new IllegalStateException(e);
		}
	}

	private URL getWsdlUrl(String host) throws MalformedURLException, URISyntaxException {
		URL signatureRequestSoapWsUrl = new URL(String.format(SIGNATURE_SOAP_WS_URL_PATTERN, host));

		// TODO: Finalizar o cache em arquivo. Por enquanto só salva. Falta fazer o reuso.

		ClientBuilder builder = getClientBuilder();

		Response response = null;
		try {
			Client client = builder.build();

			final Builder request = client.target(signatureRequestSoapWsUrl.toURI()).request();
			response = request.get();
			if (response.getStatusInfo().getFamily() != Status.Family.SUCCESSFUL)
				throw new IllegalStateException("Error " + response.getStatus() + " when try download wsdl on url '" + signatureRequestSoapWsUrl + "'.");
			InputStream wsdlDataIn = response.readEntity(InputStream.class);

			File tempFile = File.createTempFile("certillion", ".wsdl");
			final FileOutputStream out = new FileOutputStream(tempFile);
			try {
				IOUtils.copy(wsdlDataIn, out);
			} finally {
				IOUtils.closeQuietly(out);
				IOUtils.closeQuietly(wsdlDataIn);
			}

			return tempFile.toURI().toURL();
		} catch (IOException e) {
			throw new IllegalStateException();
		} finally {
			if (response != null)
				response.close();
		}
	}

	public ApplicationProviderResource getRestService(String host) {
		ClientBuilder builder = getClientBuilder();

		// HTTP Client
		Client client = builder.build();

		// Proxy
		WebTarget target = client.target(String.format(AP_REST_WS_URL_PATTERN, host));
		ResteasyWebTarget rtarget = (ResteasyWebTarget) target;
		ApplicationProviderResource restProxy = rtarget.proxy(ApplicationProviderResource.class);

		return restProxy;
	}

	private ClientBuilder builder;

	private ClientBuilder getClientBuilder() {
		if (builder == null) {
			builder = ClientBuilder.newBuilder();
			SslUtils.config(builder);
		}
		return builder;
	}

}
