package br.com.esec.icpm.libs;

import org.apache.commons.lang.StringUtils;

import br.com.esec.icpm.signer.security.SecurityConfig;

public class Configurable {

	private String keystorePath;
	private String keystoreType;
	private String keystorePassword;
	private String keyAlias;
	private String truststorePath;
	private String truststoreType;
	private String truststorePassword;
	private Boolean allowAllHosts;
	
	private String host;

	public void done() {
		SecurityConfig.setKeystorePath(keystorePath);
		SecurityConfig.setKeystoreType(keystoreType);
		SecurityConfig.setKeystorePassword(keystorePassword);
		SecurityConfig.setKeyAlias(keyAlias);
		SecurityConfig.setTruststorePath(truststorePath);
		SecurityConfig.setTruststoreType(truststoreType);
		SecurityConfig.setTruststorePassword(truststorePassword);
		SecurityConfig.setAllowAllHosts(allowAllHosts);
		
		SecurityConfig.validate();
		
		if (!StringUtils.isEmpty(host))
			Certillion.host = host;
	}
	

	public Configurable useHost(String host) {
		this.host = host;
		return this;
	}

	public Configurable keystorePath(String keystorePath) {
		this.keystorePath = keystorePath;
		return this;
	}

	public Configurable keystoreType(String keystoreType) {
		this.keystoreType = keystoreType;
		return this;
	}

	public Configurable keystorePassword(String keystorePassword) {
		this.keystorePassword = keystorePassword;
		return this;
	}

	public Configurable keyAlias(String keyAlias) {
		this.keyAlias = keyAlias;
		return this;
	}

	public Configurable truststorePath(String truststorePath) {
		this.truststorePath = truststorePath;
		return this;
	}

	public Configurable truststoreType(String truststoreType) {
		this.truststoreType = truststoreType;
		return this;
	}

	public Configurable truststorePassword(String truststorePassword) {
		this.truststorePassword = truststorePassword;
		return this;
	}

	public Configurable allowAllHosts(boolean allowAllHosts) {
		this.allowAllHosts = allowAllHosts;
		return this;
	}

}
