/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.libs;

import br.com.esec.icpm.libs.HttpClientBuilder;
import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.signer.ws.rest.SslUtils;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolingHttpClientBuilder
implements HttpClientBuilder {
    private static Logger log = LoggerFactory.getLogger(ConnectionPoolingHttpClientBuilder.class);
    private static final int MAX_CONN_TOTAL = 200;
    private static final int MAX_CONN_PER_ROUTE = 200;
    private Map<Server, ClientBuilder> builders = new HashMap<Server, ClientBuilder>();

    public Client getClient(Server server) {
        return this.getClientBuilder(server).build();
    }

    protected ClientBuilder getClientBuilder(Server server) {
        if (!this.builders.containsKey(server)) {
            log.info("Configuring a HTTP client builder to server " + server.getHost() + "...");
            ApacheHttpClient4Engine apacheHttpClient4Engine = this.buildHttpClientEngine(server);
            ResteasyClientBuilder builder = ((ResteasyClientBuilder)ResteasyClientBuilder.newBuilder()).httpEngine((ClientHttpEngine)apacheHttpClient4Engine);
            this.builders.put(server, (ClientBuilder)builder);
            log.info("HTTP client builder to server " + server.getHost() + " configured.");
        }
        return this.builders.get(server);
    }

    private ApacheHttpClient4Engine buildHttpClientEngine(Server server) {
        CloseableHttpClient httpClient = this.buildApacheHttpClient(server);
        return new ApacheHttpClient4Engine((HttpClient)httpClient, true);
    }

    private CloseableHttpClient buildApacheHttpClient(Server server) {
        org.apache.http.impl.client.HttpClientBuilder builder = HttpClients.custom().setMaxConnPerRoute(200).setMaxConnTotal(200);
        if (server.isSecure()) {
            builder.setSslcontext(SslUtils.buildSslContext()).setHostnameVerifier(SslUtils.getHostNameVerifier());
        }
        return builder.setUserAgent("Apache-HttpClient (certillion-client-library)").build();
    }
}

