package br.com.esec.icpm.libs;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;

import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;

import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import br.com.esec.icpm.signer.security.SecurityConfig;
import br.com.esec.icpm.signer.ws.rest.SslUtils;

public class ConnectionPoolingHttpClientBuilder implements HttpClientBuilder {

	private static Logger log = LoggerFactory.getLogger(ConnectionPoolingHttpClientBuilder.class);

	private static final int MAX_CONN_TOTAL = 200;
	private static final int MAX_CONN_PER_ROUTE = 200;

	@Override
	public Client getClient(Server server) {
		return getClientBuilder(server).build();
	}

	private Map<Server, ClientBuilder> builders = new HashMap<Server, ClientBuilder>();

	protected ClientBuilder getClientBuilder(Server server) {
		if (!builders.containsKey(server)) {
			log.info("Configuring a HTTP client builder to server " + server.getHost() + "...");

			// Apache HTTP Client Engine (Resteasy-Apache Link)
			ApacheHttpClient4Engine apacheHttpClient4Engine = buildHttpClientEngine(server);

			// JAXRS HTTP Client
			final ClientBuilder builder = ((ResteasyClientBuilder) ResteasyClientBuilder.newBuilder()).httpEngine(apacheHttpClient4Engine);

			builders.put(server, builder);
			log.info("HTTP client builder to server " + server.getHost() + " configured.");
		}
		return builders.get(server);
	}

	private ApacheHttpClient4Engine buildHttpClientEngine(Server server) {
		// Create a Apache Http Client
		CloseableHttpClient httpClient = buildApacheHttpClient(server);

		return new ApacheHttpClient4Engine(httpClient, true);
	}

	private CloseableHttpClient buildApacheHttpClient(Server server) {
		org.apache.http.impl.client.HttpClientBuilder builder = HttpClients.custom() // Custom
				.setMaxConnPerRoute(MAX_CONN_PER_ROUTE) // Max route connections
				.setMaxConnTotal(MAX_CONN_TOTAL); // Max total connections

		// SSL Context
		if (server.isSecure()) {
			builder.setSslcontext(SslUtils.buildSslContext())// Set SSL context
					.setHostnameVerifier(SslUtils.getHostNameVerifier()); // Set hostname verifier
		}

		return builder.setUserAgent("Apache-HttpClient (certillion-client-library)") // set user agent
				.build();
	}

}
