/*
 * Decompiled with CFR 0.152.
 */
package br.com.entelgy.liferay.dxp.drivers;

import br.com.entelgy.GenericDriver;
import br.com.entelgy.liferay.dxp.pages.LoginPage;
import com.google.common.base.Function;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationDriver
extends GenericDriver {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationDriver.class);
    protected static final String PORTAL_URL = "c/portal/";
    protected static final String LOGOUT_URL = "c/portal/logout";
    protected static final String LOGIN_URL = "c/portal/login";

    public static WebElement login(String username, String password) {
        try {
            AuthenticationDriver.getWebDriver().get(applicationContext.getServerUrl() + LOGIN_URL);
            if (!applicationContext.getUsername().isEmpty() && !applicationContext.getUsername().equals(username)) {
                AuthenticationDriver.logout();
            }
            if (applicationContext.getUsername().isEmpty()) {
                AuthenticationDriver.getWebDriver().get(applicationContext.getServerUrl() + LOGIN_URL);
                LoginPage page = (LoginPage)PageFactory.initElements((WebDriver)AuthenticationDriver.getWebDriver(), LoginPage.class);
                page.setDriver(AuthenticationDriver.getWebDriver());
                page.login(username, password);
                applicationContext.setUsername(username);
            }
            return (WebElement)new WebDriverWait(AuthenticationDriver.getWebDriver(), 30L).until((Function)ExpectedConditions.presenceOfElementLocated((By)By.className((String)"user-avatar-image")));
        }
        catch (NoSuchElementException ex) {
            LOG.error("Avatar element is not found.");
            return null;
        }
    }

    public static void logout() {
        AuthenticationDriver.getWebDriver().get(applicationContext.getServerUrl() + LOGOUT_URL);
        applicationContext.setUsername("");
    }
}

