/*
 * Decompiled with CFR 0.152.
 */
package br.com.educode.plugin.util;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class Utils {
    public static Document getDocument(String xmlFile) throws ParserConfigurationException, SAXException, IOException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xmlFile);
    }

    public static NodeList getNodeList(Document document, String tagName) {
        return document.getElementsByTagName(tagName);
    }

    public static Node getNodeByTagName(NodeList nodeList, String tagName) {
        Node wanted = null;
        int size = nodeList.getLength();
        for (int i = 0; i < size && !(wanted = nodeList.item(i)).getNodeName().equals(tagName); ++i) {
            wanted = null;
        }
        return wanted;
    }

    public static String[] getNoSnapshotArtifactIdsTextContent(Document document) {
        NodeList noSnapshotArtifactIdNodeList = Utils.getNodeList(document, "no-snapshot.artifactId");
        int size = noSnapshotArtifactIdNodeList.getLength();
        Object[] artifactIds = new String[size];
        for (int i = 0; i < size; ++i) {
            artifactIds[i] = noSnapshotArtifactIdNodeList.item(i).getTextContent();
        }
        Arrays.sort(artifactIds);
        return artifactIds;
    }

    public static String getTextContentOfDocument(Document document, String encode) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSSerializer lsSerializer = domImplLS.createLSSerializer();
        LSOutput lsOutput = domImplLS.createLSOutput();
        lsOutput.setEncoding(encode);
        lsOutput.setCharacterStream(new StringWriter());
        lsSerializer.write(document, lsOutput);
        return lsOutput.getCharacterStream().toString();
    }
}

