package br.com.edsilfer.android.lmanager.presenter

import android.os.Bundle
import android.support.annotation.NonNull
import android.support.v4.app.Fragment
import android.support.v4.view.ViewCompat
import android.support.v7.widget.LinearLayoutManager
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import br.com.edsilfer.android.lmanager.R
import br.com.edsilfer.android.lmanager.model.CustomDataSet
import br.com.edsilfer.android.lmanager.model.GenericHolderFactory
import br.com.edsilfer.android.lmanager.model.IListControl
import kotlinx.android.synthetic.main.fragment_generic_list.*
import java.io.Serializable

/**
 * Created by User on 08/11/2016.
 */

class GenericListFragment<T : Serializable>() : Fragment(), IListControl<T> {

    companion object {
        val ARG_DATASET = "ARG_DATASET"
        val ARG_ADAPTER = "ARG_ADAPTER"

        fun <T : Serializable> newInstance(@NonNull dataset: CustomDataSet<T>, @NonNull adapter: GenericHolderFactory<T>): GenericListFragment<T> {
            val fragment = GenericListFragment<T>()
            val args = Bundle()
            args.putSerializable(ARG_DATASET, dataset)
            args.putSerializable(ARG_ADAPTER, adapter)
            fragment.arguments = args
            return fragment
        }
    }

    private lateinit var mDataSet: MutableList<T>
    private lateinit var mAdapter: GenericItemAdapter<T>
    lateinit var mViewHolderFactory: GenericHolderFactory<T>

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        if (arguments == null) throw IllegalStateException("GenericListFragment must be initialized through newInstance static method")
        mDataSet = (arguments.getSerializable(ARG_DATASET) as CustomDataSet<T>).mDataset.toMutableList()
        mViewHolderFactory = arguments.getSerializable(ARG_ADAPTER) as GenericHolderFactory<T>
        mAdapter = GenericItemAdapter(mDataSet, mViewHolderFactory)
        return inflater.inflate(R.layout.fragment_generic_list, container, false)
    }

    override fun onViewCreated(view: View?, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        list.layoutManager = LinearLayoutManager(activity, LinearLayoutManager.VERTICAL, false)
        list.adapter = mAdapter
    }

    // PUBLIC INTERFACE
    override fun getDataSet(): MutableList<T> {
        return mAdapter!!.mDataSet
    }

    override fun refreshDataSet() {
        return mAdapter!!.refreshDataSet()
    }

    override fun getItem(index: Int): T {
        return mAdapter!!.getItem(index)
    }

    override fun addItem(item: T, index: Int) {
        mAdapter!!.addItem(item, index)
    }

    override fun removeItem(item: T, index: Int) {
        mAdapter!!.removeItem(item, index)
    }

    override fun updateDataSet(dataSet: MutableList<T>) {
        mAdapter!!.updateDataSet(dataSet)
    }

    override fun setNestedViewEnabled(enabled: Boolean) {
        ViewCompat.setNestedScrollingEnabled(list, enabled);
    }
}
