package br.com.edsilfer.android.lmanager.presenter.fragment

import android.os.Bundle
import android.support.v4.app.Fragment
import android.support.v4.view.ViewCompat
import android.support.v7.widget.LinearLayoutManager
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import br.com.edsilfer.android.lmanager.R
import br.com.edsilfer.android.lmanager.model.GenericHolderFactory
import br.com.edsilfer.android.lmanager.model.IListControl
import br.com.edsilfer.android.lmanager.presenter.adapter.GenericItemAdapter
import kotlinx.android.synthetic.main.fragment_generic_list.*
import java.io.Serializable

/**
 * Created by User on 08/11/2016.
 */

class GenericListFragment<T : Serializable>(
        val mViewHolderFactory: GenericHolderFactory<T>,
        val mDataSet: MutableList<T>
) : Fragment(), IListControl<T> {

    private var mAdapter: GenericItemAdapter<T>? = null

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_generic_list, container, false)
    }

    override fun onViewCreated(view: View?, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        initializeRecyclerView()
    }

    private fun initializeRecyclerView() {
        mAdapter = GenericItemAdapter(
                mDataSet,
                mViewHolderFactory
        )

        list.layoutManager = LinearLayoutManager(activity, LinearLayoutManager.VERTICAL, false)
        list.adapter = mAdapter
    }

    // PUBLIC INTERFACE
    override fun getDataSet(): MutableList<T> {
        return mAdapter!!.mDataSet
    }

    override fun refreshDataSet() {
        return mAdapter!!.refreshDataSet()
    }

    override fun getItem(index: Int): T {
        return mAdapter!!.getItem(index)
    }

    override fun addItem(item: T, index: Int) {
        mAdapter!!.addItem(item, index)
    }

    override fun removeItem(item: T, index: Int) {
        mAdapter!!.removeItem(item, index)
    }

    override fun updateDataSet(dataSet: MutableList<T>) {
        mAdapter!!.updateDataSet(dataSet)
    }

    override fun setNestedViewEnabled(enabled: Boolean) {
        ViewCompat.setNestedScrollingEnabled(list, enabled);
    }
}
