package br.com.edsilfer.android.lmanager.presenter.adapter

import android.support.v7.widget.RecyclerView
import android.view.ViewGroup
import br.com.edsilfer.android.lmanager.model.GenericHolderFactory
import br.com.edsilfer.android.lmanager.model.GenericViewHolder
import br.com.edsilfer.android.lmanager.model.IListControl

/**
 * Created by User on 08/11/2016.
 */

class GenericItemAdapter<T>(
        var mDataSet: MutableList<T>,
        val holderFactory: GenericHolderFactory<T>
) : RecyclerView.Adapter<GenericViewHolder<T>>(), IListControl<T> {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): GenericViewHolder<T> {
        return holderFactory.getViewHolder(parent)
    }

    override fun getItemCount(): Int {
        return mDataSet.size
    }

    override fun onBindViewHolder(holder: GenericViewHolder<T>, position: Int) {
        holder.onBindViewHolder(getItem(position))
        holder.getClickableItem().setOnClickListener {
            holder.onItemClicked(getItem(position), position)
        }
    }

    override fun getDataSet(): MutableList<T> {
        return mDataSet
    }

    override fun refreshDataSet() {
        notifyDataSetChanged()
    }

    // PUBLIC INTERFACE
    @Throws(ArrayIndexOutOfBoundsException::class)
    override fun getItem(index: Int): T {
        return mDataSet[index]
    }

    override fun addItem(item: T, index: Int) {
        if (index != -1) {
            mDataSet.add(index, item)
            notifyItemInserted(index)
        } else {
            mDataSet.add(item)
            notifyItemInserted(itemCount)
        }
    }

    @Throws(ArrayIndexOutOfBoundsException::class)
    override fun removeItem(item: T, index: Int) {
        if (index != -1) {
            mDataSet.remove(item)
            notifyItemRemoved(index)
        } else {
            mDataSet.remove(item)
            notifyItemRemoved(itemCount)
        }
    }

    override fun updateDataSet(dataSet: MutableList<T>) {
        mDataSet = dataSet
        notifyDataSetChanged()
    }
}
