package br.com.edsilfer.android.lmanager.presenter.fragment

import android.os.Bundle
import android.support.v4.app.Fragment
import android.support.v7.app.AppCompatActivity
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import br.com.edsilfer.android.lmanager.R
import br.com.edsilfer.android.lmanager.model.GenericHolderFactory
import br.com.edsilfer.android.lmanager.presenter.adapter.GenericItemAdapter
import br.com.edsilfer.kotlin_support.extensions.initListItems
import br.com.edsilfer.kotlin_support.extensions.log
import kotlinx.android.synthetic.main.fragment_generic_list.*
import java.io.Serializable
import java.util.*

/**
 * Created by User on 08/11/2016.
 */

class GenericListFragment<T : Serializable>() : Fragment() {

    companion object {
        private val FRAG_ARG_DATA_SET = "dataset"
        private val FRAG_ARG_GENERIC_VIEW_HOLDER = "genericviewholder"
    }

    private var mAdapter: GenericItemAdapter<T>? = null

    fun getInstance(dataSet: ArrayList<T>, factory: GenericHolderFactory<T>): GenericListFragment<T> {
        val frag = GenericListFragment<T>()
        val bundle = Bundle()
        bundle.putSerializable(FRAG_ARG_DATA_SET, dataSet)
        bundle.putSerializable(FRAG_ARG_GENERIC_VIEW_HOLDER, factory)
        frag.arguments = bundle
        return frag
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_generic_list, container, false)
    }

    override fun onViewCreated(view: View?, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        val dataSet = arguments.getSerializable(FRAG_ARG_DATA_SET) as ArrayList<T>

        log("received dataset: $dataSet")

        val holderFactory = arguments.getSerializable(FRAG_ARG_GENERIC_VIEW_HOLDER) as GenericHolderFactory<T>
        initializeRecyclerView(dataSet, holderFactory)
    }

    private fun initializeRecyclerView(dataSet: MutableList<T>, holderFactory: GenericHolderFactory<T>) {
        mAdapter = GenericItemAdapter(
                dataSet,
                holderFactory
        )

        list.initListItems(
                activity as AppCompatActivity,
                LinearLayoutManager.VERTICAL,
                null,
                mAdapter as RecyclerView.Adapter<RecyclerView.ViewHolder>
        )
    }
}
