package br.com.edsilfer.kotlin_support.extensions

import android.util.Log

fun Any.log(content: String, level: LogLevel = LogLevel.WARNING) {
    when (level) {
        LogLevel.ERROR -> Log.e(this.javaClass.simpleName, content)
        LogLevel.WARNING -> Log.i(this.javaClass.simpleName, content)
    }
}

fun Any.random(max : Int) : Int {
    return (Math.random()*max).toInt()
}