package br.com.edsilfer.kotlin_support.presenter.dialog

import android.app.Dialog
import android.support.design.widget.TextInputLayout
import android.support.v7.app.AppCompatActivity
import android.util.TypedValue
import android.view.Window
import android.widget.Button
import android.widget.EditText
import android.widget.TextView
import br.com.edsilfer.kotlin_support.R
import br.com.edsilfer.kotlin_support.presenter.layout.CustomDialog

/**
 * Provides the binding methods for a common Input Dialog interface, used in Anko Support libraries
 */
class DialogInput(var mActivity: AppCompatActivity, var noInputs: Int) {

    private var mDialog: Dialog? = null

    private var mOkay: Button? = null
    private var mCancel: Button? = null
    private var mInput1: EditText? = null
    private var mInput2: EditText? = null
    private var mInput3: EditText? = null
    private var mTitle: TextView? = null

    // LISTENERS
    private var mOnCancel: (text: List<String>) -> Unit = { }
    private var mOnAccept: (text: List<String>) -> Unit = { }
    private var mOnDismiss: (text: List<String>) -> Unit = { }

    init {
        initMembers()
    }

    // PUBLIC INTERFACE ============================================================================
    fun show(): Unit {
        mDialog!!.show()
        return
    }

    fun onAccept(onAccept: (text: List<String>) -> Unit): DialogInput {
        mOnAccept = onAccept
        return this
    }

    fun onCancel(onCancel: (text: List<String>) -> Unit): DialogInput {
        mOnCancel = onCancel
        return this
    }

    fun onDismiss(onDismiss: (text: List<String>) -> Unit): DialogInput {
        mOnDismiss = onDismiss
        return this
    }

    fun setInput1Hint(hint: String): DialogInput {
        (mDialog!!.findViewById(R.id.inputWrapper1) as TextInputLayout).hint = hint
        return this
    }

    fun setInput2Hint(hint: String): DialogInput {
        (mDialog!!.findViewById(R.id.inputWrapper2) as TextInputLayout).hint = hint
        return this
    }

    fun setInput3Hint(hint: String): DialogInput {
        (mDialog!!.findViewById(R.id.inputWrapper3) as TextInputLayout).hint = hint
        return this
    }

    fun setDialogTitle(title: String): DialogInput {
        mTitle!!.text = title
        return this
    }

    // LOADERS/INITIALIZATIONS =====================================================================
    private fun initDialog() {
        mDialog = CustomDialog(mActivity, { height, width -> })
        mDialog!!.requestWindowFeature(Window.FEATURE_NO_TITLE)
        mDialog!!.setContentView(R.layout.dlg_input)
    }

    private fun initMembers() {
        if (noInputs > 3) {
            throw IllegalArgumentException("DialogInput supports only 3 inputs")
        }

        initDialog()
        mOkay = mDialog!!.findViewById(R.id.okay) as Button
        mCancel = mDialog!!.findViewById(R.id.cancel) as Button
        mInput1 = mDialog!!.findViewById(R.id.input1) as EditText
        mInput2 = mDialog!!.findViewById(R.id.input2) as EditText
        mInput3 = mDialog!!.findViewById(R.id.input3) as EditText
        mTitle = mDialog!!.findViewById(R.id.dialog_title) as TextView

        setInputVisibility()
        setUIListeners()
    }

    private fun setInputVisibility() {
        when (noInputs) {
            1 -> {
                mDialog!!.findViewById(R.id.inputWrapper1).visibility = TextInputLayout.VISIBLE
                mDialog!!.findViewById(R.id.inputWrapper2).visibility = TextInputLayout.GONE
                mDialog!!.findViewById(R.id.inputWrapper3).visibility = TextInputLayout.GONE
            }

            2 -> {
                mDialog!!.findViewById(R.id.inputWrapper1).visibility = TextInputLayout.VISIBLE
                mDialog!!.findViewById(R.id.inputWrapper2).visibility = TextInputLayout.VISIBLE
                mDialog!!.findViewById(R.id.inputWrapper3).visibility = TextInputLayout.GONE
            }

            3 -> {
                mDialog!!.findViewById(R.id.inputWrapper1).visibility = TextInputLayout.VISIBLE
                mDialog!!.findViewById(R.id.inputWrapper2).visibility = TextInputLayout.VISIBLE
                mDialog!!.findViewById(R.id.inputWrapper3).visibility = TextInputLayout.VISIBLE
            }
        }
    }

    private fun setUIListeners() {
        onOkayClicked()
        onCancelClicked()
        onDismiss()
    }

    // UI EVENTS ===================================================================================
    private fun onOkayClicked() {
        mOkay!!.setOnClickListener {
            mOnAccept(getResults())
            mDialog!!.dismiss()
        }
    }

    private fun getResults(): MutableList<String> {
        val result = mutableListOf<String>()
        when (noInputs) {
            1 -> {
                result.add(mInput1!!.text.toString())
            }
            2 -> {
                result.add(mInput1!!.text.toString())
                result.add(mInput2!!.text.toString())
            }
            3 -> {
                result.add(mInput1!!.text.toString())
                result.add(mInput2!!.text.toString())
                result.add(mInput3!!.text.toString())
            }
        }
        return result
    }

    private fun onCancelClicked() {
        mCancel!!.setOnClickListener {
            mOnCancel(getResults())
            mDialog!!.dismiss()
        }
    }

    private fun onDismiss() {
        mDialog!!.setOnDismissListener {
            mOnDismiss(getResults())
        }
    }
}


