package br.com.edsilfer.kotlin_support.extensions

import android.content.res.ColorStateList
import android.support.v7.widget.AppCompatCheckBox

fun AppCompatCheckBox.setColor(color: Int, isResource: Boolean = true) {
    var colorStateList: ColorStateList? = null
    if (isResource) {
        colorStateList = ColorStateList(
                arrayOf(intArrayOf(-android.R.attr.state_enabled),
                        intArrayOf(android.R.attr.state_enabled)
                ),
                intArrayOf(context.resources.getColor(color), context.resources.getColor(color))
        )
    } else {
        colorStateList = ColorStateList(
                arrayOf(intArrayOf(-android.R.attr.state_enabled),
                        intArrayOf(android.R.attr.state_enabled)
                ),
                intArrayOf(color, color)
        )
    }
    supportButtonTintList = colorStateList
}