package br.com.edsilfer.kotlin_support.service.files

import android.content.Context
import android.content.SharedPreferences


/**
 * Created by User on 13/12/2016.
 */

object SharedPreferencesUtil {
    val SHARED_PREFERENCES_FILE = "generic_preferences"

    fun getSharedPreferences(context: Context): SharedPreferences {
        return context.getSharedPreferences(SHARED_PREFERENCES_FILE, Context.MODE_PRIVATE)
    }

    fun putProperty(context: Context, key: String, value: Any) {
        val sharedPref = getSharedPreferences(context)
        val editor = sharedPref.edit()
        when (value) {
            is Boolean -> editor.putBoolean(key, value)
            is String -> editor.putString(key, value)
            is Int -> editor.putInt(key, value)
            is Float -> editor.putFloat(key, value)
            is MutableSet<*> -> editor.putStringSet(key, value as MutableSet<String>)
        }
        editor.apply()
    }


    fun getProperty(context: Context, key: String, defaultValue: Any): Any? {
        val sharedPref = getSharedPreferences(context)
        when (defaultValue) {
            is Boolean -> return sharedPref.getBoolean(key, defaultValue)
            is String -> return sharedPref.getString(key, defaultValue)
            is Int -> return sharedPref.getInt(key, defaultValue)
            is Float -> return sharedPref.getFloat(key, defaultValue)
            is MutableSet<*> -> return sharedPref.getStringSet(key, defaultValue as MutableSet<String>)
            else -> return null
        }
    }
}
