package br.com.edsilfer.kotlin_support.service.communication

/**
 * Created by efernandes on 06/12/16.
 */

import android.util.Log
import br.com.edsilfer.kotlin_support.model.Email
import br.com.edsilfer.kotlin_support.model.Sender
import java.io.File
import java.security.Security
import java.util.*
import javax.activation.DataHandler
import javax.activation.FileDataSource
import javax.mail.*
import javax.mail.internet.InternetAddress
import javax.mail.internet.MimeBodyPart
import javax.mail.internet.MimeMessage
import javax.mail.internet.MimeMultipart

class EmailManager(val sender: Sender) : javax.mail.Authenticator() {

    companion object {
        val ARG_CONTENT_TYPE = "application/octet-stream"
        val ARG_NAME = "ByteArrayDataSource"
        val ARG_TYPE_TEXT_PLAIN = "text/plain"

        val PROP_MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol"
        val PROP_MAIL_SMTP_HOST = "mail.host"
        val PROP_MAIL_SMTP_AUTH = "mail.smtp.auth"
        val PROP_MAIL_SMTP_PORT = "mail.smtp.port"
        val PROP_MAIL_SMTP_SOCKET_FACTORY_PORT = "mail.smtp.socketFactory.port"
        val PROP_MAIL_SMTP_SOCKET_FACTORY_CLASS = "mail.smtp.socketFactory.class"
        val PROP_MAIL_SMTP_SOCKET_FACTORY_FALLBACK = "mail.smtp.socketFactory.fallback"
        val PROP_MAIL_SMTP_QUIT_WAIT = "mail.smtp.quitwait"

        val VALUE_MAIL_TRANSPORT_PROTOCOL = "smtp"
        val VALUE_MAIL_SMTP_HOST = "smtp.gmail.com"
        val VALUE_MAIL_SMTP_AUTH = "true"
        val VALUE_MAIL_SMTP_PORT = "465"
        val VALUE_MAIL_SMTP_SOCKET_FACTORY_PORT = "465"
        val VALUE_MAIL_SMTP_SOCKET_FACTORY_CLASS = "javax.net.ssl.SSLSocketFactory"
        val VALUE_MAIL_SMTP_SOCKET_FACTORY_FALLBACK = "false"
        val VALUE_MAIL_SMTP_QUIT_WAIT = "false"


        init {
            Security.addProvider(JSSEProvider())
        }
    }

    private val session: Session

    init {

        val props = Properties()
        props.setProperty(PROP_MAIL_TRANSPORT_PROTOCOL, VALUE_MAIL_TRANSPORT_PROTOCOL)
        props.setProperty(PROP_MAIL_SMTP_HOST, VALUE_MAIL_SMTP_HOST)
        props.put(PROP_MAIL_SMTP_AUTH, VALUE_MAIL_SMTP_AUTH)
        props.put(PROP_MAIL_SMTP_PORT, VALUE_MAIL_SMTP_PORT)
        props.put(PROP_MAIL_SMTP_SOCKET_FACTORY_PORT, VALUE_MAIL_SMTP_SOCKET_FACTORY_PORT)
        props.put(PROP_MAIL_SMTP_SOCKET_FACTORY_CLASS, VALUE_MAIL_SMTP_SOCKET_FACTORY_CLASS)
        props.put(PROP_MAIL_SMTP_SOCKET_FACTORY_FALLBACK, VALUE_MAIL_SMTP_SOCKET_FACTORY_FALLBACK)
        props.setProperty(PROP_MAIL_SMTP_QUIT_WAIT, VALUE_MAIL_SMTP_QUIT_WAIT)

        session = Session.getDefaultInstance(props, this)
    }

    override fun getPasswordAuthentication(): PasswordAuthentication {
        return PasswordAuthentication(sender.email, sender.password)
    }

    @Synchronized @Throws(Exception::class)
    fun sendMail(email: Email) {
        try {
            val message = MimeMessage(session)
            message.sender = InternetAddress(sender.email)
            message.subject = email.subject
            message.setContent(getContent(email.attachments, email.body))
            setRecipients(email, message)
            Transport.send(message)
            Log.i("EmailManager", "E-mail sent to ${email.getRecipients()} successfully")
        } catch (e: Exception) {
            Log.e("EmailManager", "Error attempting to send e-mail. Message: ${e.message}")
        }
    }

    private fun setRecipients(email: Email, message: MimeMessage) {
        if (email.recipients.size > 1) {
            message.setRecipients(Message.RecipientType.TO, InternetAddress.parse(email.getRecipients()))
        } else {
            message.setRecipient(Message.RecipientType.TO, InternetAddress(email.getRecipients()))
        }
    }

    private fun getContent(files: Array<File>, textContent: String = ""): Multipart {
        val multipart: Multipart = MimeMultipart()
        addTextContent(multipart, textContent)
        addAttachments(files, multipart)
        return multipart
    }

    private fun addAttachments(files: Array<File>, multipart: Multipart) {
        for (f in files) {
            val messageBodyPart = MimeBodyPart()
            Log.i("EmailManager", "Attaching: ${f.absolutePath}...")
            val source = FileDataSource(f.absolutePath)
            messageBodyPart.dataHandler = DataHandler(source)
            messageBodyPart.fileName = f.name
            multipart.addBodyPart(messageBodyPart)
        }
    }

    private fun addTextContent(multipart: Multipart, textContent: String) {
        if (textContent.isNotBlank()) {
            val bodyPart = MimeBodyPart()
            bodyPart.setText(textContent)
            multipart.addBodyPart(bodyPart)
        }
    }

}