package br.com.edsilfer.kotlin_support.extensions

import java.text.SimpleDateFormat
import java.util.*

fun Date.format(pattern: String): String {
    val formatter = SimpleDateFormat(pattern)
    return formatter.format(this)
}

fun Date.getDayOfMonth(): Int {
    val cal = Calendar.getInstance()
    cal.time = this
    return cal.get(Calendar.DAY_OF_MONTH)
}

fun Date.getDayOfWeek(): Int {
    val cal = Calendar.getInstance()
    cal.time = this
    return cal.get(Calendar.DAY_OF_WEEK)
}

fun Date.getMonth(): Int {
    val cal = Calendar.getInstance()
    cal.time = this
    return cal.get(Calendar.MONTH)
}

fun Date.getYear(): Int {
    val cal = Calendar.getInstance()
    cal.time = this
    return cal.get(Calendar.YEAR)
}

