package br.com.edsilfer.kotlin_support.service.files

import android.util.Log
import mf.javax.xml.transform.stream.StreamSource
import mf.org.apache.xerces.jaxp.validation.XMLSchemaFactory
import java.io.File
import java.io.InputStream

object XMLValidator {
    fun validateAgainstSchema(xml: String, schema: String): Boolean {
        val factory = XMLSchemaFactory()
        val schemaFile = StreamSource(File(schema))
        val xmlSource = StreamSource(File(xml))
        factory.newSchema(schemaFile).newValidator().validate(xmlSource)
        return true
    }

    fun validateAgainstSchema(xml: InputStream?, schema: InputStream?): Boolean {
        try {
            XMLSchemaFactory().newSchema(StreamSource(schema)).newValidator().validate(StreamSource(xml))
        } catch (e : Exception) {
            Log.e("XMLValidator", "Validation not passed due to following error: ${e.message}. Given XML is not compliant with given XSD")
            return false
        }
        return true
    }
}