package br.com.edsilfer.kotlin_support.service.communication

/**
 * Created by efernandes on 06/12/16.
 */

import java.security.AccessController
import java.security.Provider

class JSSEProvider : Provider("HarmonyJSSE", 1.0, "Harmony JSSE Provider") {

    companion object {
        val PROP_SSL_CONTEXT_TLS = "SSLContext.TLS"
        val PROP_ALG_ALIAS_SSL_CONTEXT_TSL_V1 = "Alg.Alias.SSLContext.TLSv1"
        val PROP_KEY_MANAGER_FACTORY_X509 = "KeyManagerFactory.X509"
        val PROP_TRUST_MANAGER_FACTORY_X509 = "TrustManagerFactory.X509"

        val VALUE_SSL_CONTEXT_TLS = "org.apache.harmony.xnet.provider.jsse.SSLContextImpl"
        val VALUE_ALG_ALIAS_SSL_CONTEXT_TSL_V1 = "TLS"
        val VALUE_KEY_MANAGER_FACTORY_X509 = "org.apache.harmony.xnet.provider.jsse.KeyManagerFactoryImpl"
        val VALUE_TRUST_MANAGER_FACTORY_X509 = "org.apache.harmony.xnet.provider.jsse.TrustManagerFactoryImpl"
    }

    init {
        AccessController.doPrivileged(java.security.PrivilegedAction<Void> {
            put(PROP_SSL_CONTEXT_TLS, VALUE_SSL_CONTEXT_TLS)
            put(PROP_ALG_ALIAS_SSL_CONTEXT_TSL_V1, VALUE_ALG_ALIAS_SSL_CONTEXT_TSL_V1)
            put(PROP_KEY_MANAGER_FACTORY_X509, VALUE_KEY_MANAGER_FACTORY_X509)
            put(PROP_TRUST_MANAGER_FACTORY_X509, VALUE_TRUST_MANAGER_FACTORY_X509)
            null
        })
    }
}