package br.com.edsilfer.kotlin_support.model

import android.content.Context
import android.os.Environment
import android.os.Environment.MEDIA_MOUNTED
import android.os.Environment.getExternalStorageDirectory
import android.util.Log
import br.com.edsilfer.kotlin_support.commons.Constants
import java.io.File


/**
 * Created by User on 05/12/2016.
 */
enum class DirectoryPath(var mValue: String) {

    INTERNAL(""), EXTERNAL(Environment.getExternalStorageDirectory().toString());

    fun getValue(context: Context): String {
        if (mValue.isNullOrEmpty()) return "${context.filesDir.absolutePath}/"
        else return "$mValue/"
    }
}