package br.com.edsilfer.kotlin_support.service.keyboard

import android.text.Editable
import android.text.TextWatcher
import android.widget.EditText

/**
 * Created by User on 03/12/2016.
 */

abstract class EnhancedTextWatcher(val mInput: EditText) : TextWatcher {

    private var snapshot = ""

    override fun afterTextChanged(sequence: Editable?) {
    }

    override fun beforeTextChanged(sequence: CharSequence?, start: Int, count: Int, after: Int) {
        snapshot = mInput.text.toString()
    }

    override fun onTextChanged(sequence: CharSequence?, start: Int, previousLength: Int, count: Int) {
        onTextChanged(start, count == 0, if (count == 0) snapshot[start] else ' ')
    }

    abstract fun onTextChanged(cursor: Int, isBackspace: Boolean, deletedChar: Char)
}
