package br.com.edsilfer.kotlin_support.presenter.layout

import android.annotation.TargetApi
import android.content.Context
import android.os.Build
import android.util.AttributeSet
import android.util.TypedValue
import android.view.LayoutInflater
import android.widget.LinearLayout
import br.com.edsilfer.kotlin_support.R
import com.gc.materialdesign.views.ProgressBarCircularIndeterminate

/**
 * Created by edgar on 11-May-16.
 */
class CircularProgressBar : LinearLayout {
    constructor(context: Context) : super(context) {
        init(context, null)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        init(context, attrs)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(context, attrs, defStyleAttr) {
        init(context, attrs)
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int, defStyleRes: Int) : super(context, attrs, defStyleAttr, defStyleRes) {
        init(context, attrs)
    }

    private fun init(context: Context, attrs: AttributeSet?) {
        val inflater = context.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater
        val rootView = inflater.inflate(R.layout.rsc_util_loading_indeterminate_circular, this, true)
        val progressBar = rootView.findViewById(R.id.circular_progress_bar) as ProgressBarCircularIndeterminate
        progressBar.setBackgroundColor(getColor(context, attrs))
    }

    private fun getColor(context: Context, attrs: AttributeSet?): Int {
        if (attrs != null) {
            val typedArray = context.obtainStyledAttributes(attrs, R.styleable.ProgressBar)
            return typedArray.getColor(R.styleable.ProgressBar_colorLine, -1)
        } else {
            val value = TypedValue()
            context.theme.resolveAttribute(R.attr.colorPrimaryDark, value, true)
            return value.data
        }
    }
}