package br.com.edsilfer.kiwi.notification;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AppCompatActivity;
import android.text.Html;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;

import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;

import br.com.edsilfer.kiwi.R;
import br.com.edsilfer.kiwi.commons.Constants;

/**
 * Created by edgar on 11-May-16.
 */
public class NotificationManager {


    public void showErrorPopUp(Context context, String content) {
        new MaterialDialog.Builder(context)
                .title(Html.fromHtml("<b><font color='#c53929'>".concat(Constants.NotificationInterface.INFO_ERROR_TITLE).concat("</d></font>")))
                .content(content)
                .positiveText(Constants.NotificationInterface.BUTTON_OKAY)
                .positiveColor(context.getResources().getColor(android.R.color.holo_red_dark))
                .show();
    }

    public void showWarningPopUp(Context context, String content) {
        new MaterialDialog.Builder(context)
                .title(Html.fromHtml("<b><font color='#FFCC00'>".concat(Constants.NotificationInterface.INFO_WARNING_TITLE).concat("</d></font>")))
                .content(content)
                .positiveText(Constants.NotificationInterface.BUTTON_OKAY)
                .positiveColor(context.getResources().getColor(R.color.rsc_dialog_warning))
                .show();
    }

    public void showPopUp(Context context, String title, String content, int color) {
        final TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorPrimaryDark, value, true);
        new MaterialDialog.Builder(context)
                .title(title)
                .titleColor(value.data)
                .content(content)
                .positiveText(Constants.NotificationInterface.BUTTON_OKAY)
                .positiveColor(value.data)
                .negativeColor(value.data)
                .negativeText(Constants.NotificationInterface.BUTTON_CANCEL)
                .show();
    }

    public void showPopUp(Context context, String title, String content, int color, final DialogCallback callback) {
        final TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorPrimaryDark, value, true);
        new MaterialDialog.Builder(context)
                .title(title)
                .titleColor(value.data)
                .content(content)
                .positiveText(Constants.NotificationInterface.BUTTON_OKAY)
                .positiveColor(value.data)
                .negativeColor(value.data)
                .negativeText(Constants.NotificationInterface.BUTTON_CANCEL)
                .onPositive(new MaterialDialog.SingleButtonCallback() {
                    @Override
                    public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                        callback.onAccept();
                    }
                })
                .onNegative(new MaterialDialog.SingleButtonCallback() {
                    @Override
                    public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                        callback.onRefuse();
                    }
                })
                .show();
    }

    public void showUnderConstructionPopUp(Context context, int color) {
        final TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorPrimaryDark, value, true);
        new MaterialDialog.Builder(context)
                .title(Constants.NotificationInterface.INFO_UNDER_CONSTRUCTION_TITLE)
                .titleColor(value.data)
                .content(Constants.NotificationInterface.INFO_UNDER_CONSTRUCTION_MESSAGE)
                .positiveText(Constants.NotificationInterface.BUTTON_OKAY)
                .positiveColor(value.data)
                .negativeText("")
                .show();
    }

    public void showSnackAlert(AppCompatActivity activity, final View view, String message) {
        try {
            final Snackbar snackbar = Snackbar.make(view, "", Snackbar.LENGTH_LONG);
            Snackbar.SnackbarLayout layout = (Snackbar.SnackbarLayout) snackbar.getView();

            View customView = activity.getLayoutInflater().inflate(R.layout.rsc_util_notification_snackbar, null);
            TextView customText = (TextView) customView.findViewById(R.id.snackbar_text);
            customText.setText(message);

            layout.addView(customView, 0);
            snackbar.show();
        } catch (Exception e) {
            e.printStackTrace();
            throw (new RuntimeException(Constants.EXCEPTION_LAYOUT_MISSING.replace(Constants.PLACEHOLDER, Constants.NotificationInterface.LAYOUT_SNACK_BAR)));
        }
    }

    public interface DialogCallback {
        void onAccept();

        void onRefuse();
    }

}
