package br.com.edsilfer.kiwi.loading;

import android.app.Activity;
import android.os.Handler;
import android.support.v7.widget.CardView;

import com.gc.materialdesign.views.ProgressBarIndeterminate;

import br.com.edsilfer.kiwi.R;
import br.com.edsilfer.kiwi.commons.Constants;

/**
 * Created by edgar on 11-May-16.
 */
public class LoaderManager {
    public void showCircularProgressBar(final Activity act) {
        try {
            Handler mainHandler = new Handler(act.getMainLooper());
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    CardView circularProgressBar = (CardView) act.findViewById(R.id.circularProgressBar);
                    circularProgressBar
                            .animate()
                            .translationY(act.getResources().getDimension(R.dimen.rsc_circular_progress_bar_height) / 2)
                            .alpha(1)
                            .setDuration(Constants.LoadingInterface.LAYOUT_PROGRESS_BAR_INDETERMINATE_CIRCULAR_CIRCULAR_DURATION);

                }
            };
            mainHandler.post(myRunnable);
        } catch (Exception e) {
            throw (
                    new RuntimeException(
                            Constants.EXCEPTION_LAYOUT_MISSING
                                    .replace(Constants.PLACEHOLDER, Constants.LoadingInterface.LAYOUT_PROGRESS_BAR_INDETERMINATE_CIRCULAR
                                    )
                    ));
        }
    }

    public void hideCircularProgressBar(final Activity act) {
        try {
            CardView circularProgressBar = (CardView) act.findViewById(R.id.circularProgressBar);
            circularProgressBar
                    .animate()
                    .translationY(-act.getResources().getDimension(R.dimen.rsc_circular_progress_bar_height) / 2)
                    .alpha(0)
                    .setDuration(Constants.LoadingInterface.LAYOUT_PROGRESS_BAR_INDETERMINATE_CIRCULAR_CIRCULAR_DURATION);
        } catch (Exception e) {
            throw (
                    new RuntimeException(
                            Constants.EXCEPTION_LAYOUT_MISSING
                                    .replace(Constants.PLACEHOLDER, Constants.LoadingInterface.LAYOUT_PROGRESS_BAR_INDETERMINATE_CIRCULAR
                                    )
                    ));
        }
    }

    public void showIndeterminateProgressBar(Activity act) {
        try {
            ProgressBarIndeterminate progressBar = (ProgressBarIndeterminate) act.findViewById(R.id.progress_bar);
            progressBar.setVisibility(ProgressBarIndeterminate.VISIBLE);
        } catch (Exception e) {
            throw (
                    new RuntimeException(
                            Constants.EXCEPTION_LAYOUT_MISSING
                                    .replace(Constants.PLACEHOLDER, Constants.LoadingInterface.LAYOUT_PROGRESS_BAR_INDETERMINATE_CIRCULAR
                                    )
                    ));
        }
    }

    public void hideIndeterminateProgressBar(Activity act) {
        try {
            ProgressBarIndeterminate progressBar = (ProgressBarIndeterminate) act.findViewById(R.id.progress_bar);
            progressBar.setVisibility(ProgressBarIndeterminate.GONE);
        } catch (Exception e) {
            throw (
                    new RuntimeException(
                            Constants.EXCEPTION_LAYOUT_MISSING
                                    .replace(Constants.PLACEHOLDER, Constants.LoadingInterface.LAYOUT_PROGRESS_BAR_INDETERMINATE_CIRCULAR
                                    )
                    ));
        }
    }

}
