package br.com.edsilfer.kiwi.layout;

import android.content.Context;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ListView;

/**
 * Created by edgar on 02-May-16.
 */
public class RecyclerViewUtil {

    public RecyclerView initListItems(
            AppCompatActivity activity,
            int id,
            int layout,
            RecyclerViewOnItemClick onClickListener,
            RecyclerView.Adapter<RecyclerView.ViewHolder> adapter
    ) {
        RecyclerView recyclerView = (RecyclerView) activity.findViewById(id);
        recyclerView.setLayoutManager(new LinearLayoutManager(activity, layout, false));
        recyclerView.setAdapter(adapter);

        if (onClickListener != null) {
            recyclerView.addOnItemTouchListener(onClickListener);
        }

        return recyclerView;
    }

    public void fixRecyclerViewSize(int itemHeight, RecyclerView list) {
        int viewHeight = itemHeight * list.getAdapter().getItemCount();
        list.getLayoutParams().height = viewHeight;
    }

    public void fixListViewSize(int itemHeight, ListView list) {
        int viewHeight = itemHeight * list.getAdapter().getCount();
        list.getLayoutParams().height = viewHeight;
    }

    public static class RecyclerViewOnItemClick implements RecyclerView.OnItemTouchListener {

        private OnItemClickListener mListener;

        public interface OnItemClickListener {
            public void onItemClick(View view, int position);
        }

        GestureDetector mGestureDetector;

        public RecyclerViewOnItemClick(Context context, OnItemClickListener listener) {
            mListener = listener;
            mGestureDetector = new GestureDetector(context, new GestureDetector.SimpleOnGestureListener() {
                @Override
                public boolean onSingleTapUp(MotionEvent e) {
                    return true;
                }
            });
        }

        @Override
        public boolean onInterceptTouchEvent(RecyclerView view, MotionEvent e) {
            View childView = view.findChildViewUnder(e.getX(), e.getY());
            if (childView != null && mListener != null && mGestureDetector.onTouchEvent(e)) {
                mListener.onItemClick(childView, view.getChildLayoutPosition(childView));
            }
            return false;
        }

        @Override
        public void onTouchEvent(RecyclerView view, MotionEvent motionEvent) {
        }

        @Override
        public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {

        }
    }
}
