package br.com.edsilfer.kiwi.infra;

import android.Manifest;
import android.app.Activity;
import android.content.pm.PackageManager;
import android.support.v4.app.ActivityCompat;
import android.util.Log;

import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;

/**
 * Created by edgar on 08-May-16.
 */
public class PermissionsManager {

    private static final int PLAY_SERVICES_RESOLUTION_REQUEST = 9000;
    private static final String TAG = "PermissionsManager";

    public Boolean checkPermissionGranted (Activity activity, String permission, Boolean askPermission, int requestCode) {
        int result = ActivityCompat.checkSelfPermission(activity, permission);
        if (result != PackageManager.PERMISSION_GRANTED) {
            return Boolean.TRUE;
        } else {
            if (askPermission) {
                requestPermission(activity, new String[]{permission}, requestCode);
            }
            return Boolean.FALSE;
        }
    }

    public void requestPermission (Activity activity, String[] permissions, int requestCode) {
        ActivityCompat.requestPermissions(activity, permissions, 1);
    }

    public static boolean checkPlayServices(Activity activity) {
       GoogleApiAvailability apiAvailability = GoogleApiAvailability.getInstance();
        int resultCode = apiAvailability.isGooglePlayServicesAvailable(activity);
        if (resultCode != ConnectionResult.SUCCESS) {
            if (apiAvailability.isUserResolvableError(resultCode)) {
                apiAvailability.getErrorDialog(activity, resultCode, PLAY_SERVICES_RESOLUTION_REQUEST).show();
            } else {
                Log.i(TAG, "This device is not supported.");
                activity.finish();
            }
            return false;
        }
        return true;
    }
}
