package br.com.edsilfer.kiwi.managers;

import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;

import br.com.edsilfer.kiwi.R;


/**
 * Created by edgar on 28/02/2016.
 */
public class ToolbarManager {

    public static final String TAG = "ToolbarManager";

    private AppCompatActivity mActivity;
    private Toolbar mToolbar;

    // PUBLIC INTERFACE
    public void initToolbar(AppCompatActivity activity, String title, int toolbarID, int color) {
        this.mActivity = activity;
        this.mToolbar = (Toolbar) this.mActivity.findViewById(toolbarID);
        this.mActivity.setSupportActionBar(this.mToolbar);
        this.mActivity.getSupportActionBar().setTitle(title);
        this.mToolbar.setTitleTextColor(mActivity.getResources().getColor(color));
    }

    public void setNavigationReturnBehavior() {
        this.mToolbar.setNavigationIcon(R.drawable.ic_arrow_left_white_24dp);
        this.mActivity.getSupportActionBar().setHomeButtonEnabled(true);
        this.mToolbar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mActivity.finish();
            }
        });
    }

    public void prepareNavigationBehavior(Integer icon, final OnIconClicked executor) {
        if (icon != null) {
            this.mToolbar.setNavigationIcon(icon);
        }
        this.mActivity.getSupportActionBar().setHomeButtonEnabled(true);
        if (executor != null) {
            this.mToolbar.setNavigationOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    executor.executeTask();
                }
            });
        }
    }

    public void setNavigationIcon(int icon) {
        mToolbar.setNavigationIcon(icon);
    }

    public Toolbar getToolbar() {
        return mToolbar;
    }

    public interface OnIconClicked {
        public void executeTask();
    }
}
