package br.com.edsilfer.kiwi.loading;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.gc.materialdesign.views.ProgressBarCircularIndeterminate;

import br.com.edsilfer.kiwi.R;

/**
 * Created by edgar on 11-May-16.
 */
public class CircularProgressBar extends LinearLayout {

    private static final String TAG = "CircularProgressBar";

    public CircularProgressBar(Context context) {
        super(context);
        init(context, null);
    }

    public CircularProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public CircularProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    public CircularProgressBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View rootView = inflater.inflate(R.layout.rsc_util_loading_indeterminate_circular, this, true);
        ProgressBarCircularIndeterminate progressBar =  (ProgressBarCircularIndeterminate) rootView.findViewById(R.id.circular_progress_bar);
        progressBar.setBackgroundColor(getColor(context, attrs));
    }

    private int getColor(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LineProgressBar);
            return typedArray.getColor(R.styleable.LineProgressBar_colorLine, -1);
        } else {
            final TypedValue value = new TypedValue();
            context.getTheme().resolveAttribute(R.attr.colorPrimaryDark, value, true);
            return value.data;
        }
    }
}