package br.com.edsilfer.kiwi.notification;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.TypedValue;
import android.view.View;

import javax.inject.Inject;

import br.com.edsilfer.kiwi.R;

/**
 * Created by r720929 on 25/05/2016.
 */
public class SwipeDialog extends ItemTouchHelper.SimpleCallback {

    private static final String TAG = "SwipeDialog";

    private Activity mActivity;
    private RecyclerView mRecyclerView;
    private EventSetup mLeftHandler;
    private EventSetup mRightHandler;

    private NotificationManager mNotificationManager;

    private SwipeDialog(Activity activity, RecyclerView target, EventSetup left, EventSetup right) {
        super(0, ItemTouchHelper.LEFT | ItemTouchHelper.RIGHT);
        mNotificationManager = new NotificationManager();
        mRecyclerView = target;
        mActivity = activity;
        mLeftHandler = left;
        mRightHandler = right;

        ItemTouchHelper itemTouchHelper = new ItemTouchHelper(this);
        itemTouchHelper.attachToRecyclerView(mRecyclerView);
    }

    public static void addOnSwipeDialog(Activity activity, RecyclerView target, EventSetup left, EventSetup right) {
        new SwipeDialog(activity, target, left, right);
    }

    @Override
    public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
        return false;
    }

    @Override
    public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        final int position = viewHolder.getAdapterPosition();
        final TypedValue value = new TypedValue();
        mActivity.getTheme().resolveAttribute(R.attr.colorPrimaryDark, value, true);
        if (direction == ItemTouchHelper.LEFT && null != mLeftHandler) {
            mNotificationManager.showPopUp(
                    mActivity,
                    mLeftHandler.title,
                    mLeftHandler.content,
                    value.data,
                    new NotificationManager.DialogCallback() {
                        @Override
                        public void onAccept() {
                            if (mLeftHandler.listener != null) {
                                mLeftHandler.listener.accept(position);
                            }
                        }

                        @Override
                        public void onRefuse() {
                            if (mLeftHandler.listener != null) {
                                mLeftHandler.listener.deny(position);
                            }
                        }

                        @Override
                        public void onDismiss() {

                        }
                    });
        } else if (direction == ItemTouchHelper.RIGHT && null != mRightHandler) {
            mNotificationManager.showPopUp(
                    mActivity,
                    mRightHandler.title,
                    mRightHandler.title,
                    value.data,
                    new NotificationManager.DialogCallback() {
                        @Override
                        public void onAccept() {
                            if (mRightHandler.listener != null) {
                                mRightHandler.listener.accept(position);
                            }
                        }

                        @Override
                        public void onRefuse() {
                            if (mRightHandler.listener != null) {
                                mRightHandler.listener.deny(position);
                            }
                        }

                        @Override
                        public void onDismiss() {

                        }
                    });
        }
    }

    @Override
    public void onChildDraw(Canvas c,
                            RecyclerView recyclerView,
                            RecyclerView.ViewHolder viewHolder,
                            float dx,
                            float dy,
                            int actionState,
                            boolean isCurrentlyActive) {
        if (actionState == ItemTouchHelper.ACTION_STATE_SWIPE) {
            if (dx > 0 && null != mRightHandler) {
                drawEffect(viewHolder, c, dx, mRightHandler.getIcon(), mRightHandler.getColor(), 0);
                super.onChildDraw(c, recyclerView, viewHolder, dx, dy, actionState, isCurrentlyActive);
            } else if (dx <= 0 && null != mLeftHandler) {
                drawEffect(viewHolder, c, dx, mLeftHandler.getIcon(), mLeftHandler.getColor(), 1);
                super.onChildDraw(c, recyclerView, viewHolder, dx, dy, actionState, isCurrentlyActive);
            }
        }
    }

    private void drawEffect(RecyclerView.ViewHolder viewHolder, Canvas c, float dx, int icon, int color, int side) {
        View itemView = viewHolder.itemView;
        Paint p = new Paint();
        Bitmap b = null;
        RectF icon_dest;
        RectF background;

        float height = (float) itemView.getBottom() - (float) itemView.getTop();
        float width = height / 3;
        p.setColor(mActivity.getResources().getColor(color));

        if (side == 0) {
            background = new RectF(
                    (float) itemView.getLeft(),
                    (float) itemView.getTop(),
                    dx,
                    (float) itemView.getBottom()
            );

            icon_dest = new RectF(
                    (float) itemView.getLeft() + width,
                    (float) itemView.getTop() + width,
                    (float) itemView.getLeft() + 2 * width,
                    (float) itemView.getBottom() - width
            );
        } else {
            background = new RectF(
                    (float) itemView.getRight() + dx,
                    (float) itemView.getTop(),
                    (float) itemView.getRight(),
                    (float) itemView.getBottom()
            );

            icon_dest = new RectF(
                    (float) itemView.getRight() - 2 * width,
                    (float) itemView.getTop() + width,
                    (float) itemView.getRight() - width,
                    (float) itemView.getBottom() - width
            );
        }

        c.drawRect(background, p);
        b = BitmapFactory.decodeResource(mActivity.getResources(), icon);
        c.drawBitmap(b, null, icon_dest, p);
    }

    public interface DialogResponse {
        void accept(int position);

        void deny(int position);

        void dismissed ();
    }

    public static class EventSetup {
        private String title;
        private String content;
        private int color;
        private int icon;
        private DialogResponse listener;

        public EventSetup(String title, String content, int color, int icon, DialogResponse listener) {
            this.title = title;
            this.content = content;
            this.color = color;
            this.icon = icon;
            this.listener = listener;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public int getColor() {
            return color;
        }

        public void setColor(int mColor) {
            this.color = mColor;
        }

        public int getIcon() {
            return icon;
        }

        public void setIcon(int icon) {
            this.icon = icon;
        }

        public DialogResponse getListener() {
            return listener;
        }

        public void setListener(DialogResponse listener) {
            this.listener = listener;
        }
    }
}
