package br.com.edsilfer.kiwi.layout;

import android.app.Activity;
import android.graphics.Typeface;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.ogaclejapan.smarttablayout.SmartTabLayout;

/**
 * Created by r720929 on 17/05/2016.
 */
public class SmartToolbarUtil {

    private TextView mTabTitle[];

    private SmartTabLayout.TabProvider initViewPager(final Activity activity, final String[] titles, final int layoutID, final int titleID) {
        mTabTitle = new TextView[titles.length];
        SmartTabLayout.TabProvider aux = new SmartTabLayout.TabProvider() {
            @Override
            public View createTabView(ViewGroup container, int position, PagerAdapter adapter) {
                View itemView = activity.getLayoutInflater().inflate(layoutID, container, false);
                TextView title = (TextView) itemView.findViewById(titleID);
                title.setTypeface(null, Typeface.NORMAL);

                for (int i = 0; i < title.length(); i++) {
                    if (i == position) {
                        SmartToolbarUtil.this.mTabTitle[i] = title;
                        title.setText(titles[i]);
                        title.setTypeface(null, Typeface.BOLD);
                    }
                }

                return itemView;
            }
        };
        return aux;
    }

    public void setListener (ViewPager viewPager, final int colorActive, final int colorDesactive) {
        viewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                updateTabTitleColor(position, colorActive, colorDesactive);
            }

            @Override
            public void onPageSelected(int position) {
            }

            @Override
            public void onPageScrollStateChanged(int state) {
            }
        });

        viewPager.setCurrentItem(0);
    }

    private void updateTabTitleColor(int position, int colorActive, int colorDesactive) {
        for (int i = 0; i < mTabTitle.length; i++) {
            if (position == i) {
                mTabTitle[i].setTextColor(colorActive);
            } else {
                this.mTabTitle[i].setTextColor(colorDesactive);
            }
        }
    }
}
