package br.com.edsilfer.kiwi.layout;

import android.app.Activity;
import android.util.TypedValue;
import android.widget.TextView;

import java.util.Calendar;
import com.wdullaer.materialdatetimepicker.date.DatePickerDialog;
import br.com.edsilfer.kiwi.R;


/**
 * Created by r720929 on 24/05/2016.
 */
public class DatePickerUtil implements DatePickerDialog.OnDateSetListener {

    private TextView mDateOfBirth;

    public void startDatePicker (Activity activity, TextView initialDate) {
        mDateOfBirth = initialDate;
        final TypedValue value = new TypedValue();
        activity.getTheme().resolveAttribute(R.attr.colorPrimaryDark, value, true);
        String parts[] = mDateOfBirth.getText().toString().split("/");
        DatePickerDialog dpd = null;

        if (null != parts && parts.length == 3) {
            dpd = DatePickerDialog.newInstance(
                    this,
                    Integer.parseInt(parts[2]),
                    Integer.parseInt(parts[1]) - 1,
                    Integer.parseInt(parts[0])
            );
        } else {
            Calendar now = Calendar.getInstance();
            dpd = DatePickerDialog.newInstance(
                    this,
                    now.get(Calendar.YEAR),
                    now.get(Calendar.MONTH),
                    now.get(Calendar.DAY_OF_MONTH)
            );
        }

        dpd.setAccentColor(activity.getResources().getColor(value.data));
        dpd.show(activity.getFragmentManager(), "Datepickerdialog");
    }

    @Override
    public void onDateSet(DatePickerDialog view, int year, int monthOfYear, int dayOfMonth) {
        StringBuilder result = new StringBuilder()
                .append(dayOfMonth).append("/")
                .append((monthOfYear + 1)).append("/")
                .append(year).append(" ");
        mDateOfBirth.setText(result);
    }

}
