/*
 * Decompiled with CFR 0.152.
 */
package editor.docx.tabela;

import editor.docx.tabela.Celula;
import editor.docx.tabela.FormatacaoDaTabela;
import editor.docx.tabela.Linha;
import editor.docx.tabela.Tabela;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class AdicionaLinhaNaTabelaDoDocumentoDeTexto {
    private static final Integer PRIMEIRA_POSICAO = 0;
    private static final Integer UM = 1;
    private final List<Tabela> tabelasParaDocumentoDeTextos;
    private final List<FormatacaoDaTabela> formatacoesDasTabelas;

    private AdicionaLinhaNaTabelaDoDocumentoDeTexto(List<Tabela> tabelasParaDocumentoDeTextos, FormatacaoDaTabela ... formatacaoDasTabelas) {
        this.tabelasParaDocumentoDeTextos = tabelasParaDocumentoDeTextos;
        this.formatacoesDasTabelas = Arrays.asList(formatacaoDasTabelas);
    }

    public static AdicionaLinhaNaTabelaDoDocumentoDeTexto comTabelas(List<Tabela> tabelasParaDocumentoDeTextos, FormatacaoDaTabela ... formatacaoDaTabela) {
        return new AdicionaLinhaNaTabelaDoDocumentoDeTexto(tabelasParaDocumentoDeTextos, formatacaoDaTabela);
    }

    public static AdicionaLinhaNaTabelaDoDocumentoDeTexto comTabelas(Tabela tabelasParaDocumentoDeTextos, FormatacaoDaTabela ... formatacaoDaTabela) {
        return new AdicionaLinhaNaTabelaDoDocumentoDeTexto(Arrays.asList(tabelasParaDocumentoDeTextos), formatacaoDaTabela);
    }

    public AdicionaLinhaNaTabelaDoDocumentoDeTexto adicionarConteudoNasTabelasDoDocumentoDeTexto(List<XWPFTable> xwpfTables) {
        List xwpfTablesDocument = xwpfTables.stream().filter(xwpfTable -> this.tabelaDoDocumentoPossuiApenasOCabecalho((XWPFTable)xwpfTable)).collect(Collectors.toList());
        if (!xwpfTablesDocument.isEmpty()) {
            for (Tabela tabelaParaDocumentoDeTexto : this.tabelasParaDocumentoDeTextos) {
                Integer posicaoDaTabelaNoDocumento = this.tabelasParaDocumentoDeTextos.indexOf(tabelaParaDocumentoDeTexto);
                Optional<FormatacaoDaTabela> formatacaoDaTabela = !this.formatacoesDasTabelas.isEmpty() ? this.obterFormatacaoDaTabela(posicaoDaTabelaNoDocumento) : Optional.empty();
                this.editarTabelaDoDocumento((XWPFTable)xwpfTablesDocument.get(posicaoDaTabelaNoDocumento), this.tabelasParaDocumentoDeTextos.get(posicaoDaTabelaNoDocumento), formatacaoDaTabela);
            }
        }
        return this;
    }

    private boolean tabelaDoDocumentoPossuiApenasOCabecalho(XWPFTable xwpfTable) {
        return xwpfTable.getRows().size() == UM.intValue();
    }

    private Optional<FormatacaoDaTabela> obterFormatacaoDaTabela(Integer posicao) {
        return this.formatacoesDasTabelas.size() >= UM ? Optional.of(this.formatacoesDasTabelas.get(posicao)) : Optional.of(this.formatacoesDasTabelas.get(PRIMEIRA_POSICAO));
    }

    private void editarTabelaDoDocumento(XWPFTable xwpfTable, Tabela tabelaParaDocumentoDeTexto, Optional<FormatacaoDaTabela> formatacaoDaTabela) {
        if (tabelaParaDocumentoDeTexto != null) {
            this.adicionarLinhasNaTabela(xwpfTable, tabelaParaDocumentoDeTexto.getLinhas(), formatacaoDaTabela);
        }
    }

    private void adicionarLinhasNaTabela(XWPFTable xwpfTable, List<Linha> linhasDaTabela, Optional<FormatacaoDaTabela> formatacaoDaTabela) {
        linhasDaTabela.forEach(linhaDaTabela -> this.adicionarLinhaNaTabela(xwpfTable, linhasDaTabela, (Linha)linhaDaTabela, formatacaoDaTabela));
    }

    private void adicionarLinhaNaTabela(XWPFTable xwpfTable, List<Linha> linhasDaTabela, Linha linhaDaTabela, Optional<FormatacaoDaTabela> formatacaoDaTabela) {
        xwpfTable.createRow();
        Integer posicaoDaLinhaDaTabela = linhasDaTabela.indexOf(linhaDaTabela) + UM;
        XWPFTableRow xwpfTableRow = xwpfTable.getRow(posicaoDaLinhaDaTabela.intValue());
        this.adicionarCelulasNaLinhaDaTabela(linhaDaTabela, xwpfTableRow, formatacaoDaTabela);
    }

    private void adicionarCelulasNaLinhaDaTabela(Linha linhaDaTabela, XWPFTableRow xwpfTableRow, Optional<FormatacaoDaTabela> formatacaoDaTabela) {
        List<Celula> celulasDaLinha = linhaDaTabela.getCelulas();
        celulasDaLinha.forEach(celulaDaLinha -> this.adicionarCelulaNaLinhaDaTabela(xwpfTableRow, celulasDaLinha, (Celula)celulaDaLinha, formatacaoDaTabela));
    }

    private void adicionarCelulaNaLinhaDaTabela(XWPFTableRow xwpfTableRow, List<Celula> celulasDaLinha, Celula celulaDaLinha, Optional<FormatacaoDaTabela> formatacaoDaTabela) {
        Integer posicaoDaCelulaDaTabela = celulasDaLinha.indexOf(celulaDaLinha);
        XWPFTableCell cell = xwpfTableRow.getCell(posicaoDaCelulaDaTabela.intValue());
        if (cell != null) {
            XWPFRun xwpfRun = cell.addParagraph().createRun();
            xwpfRun.setFontFamily(this.definirFonteDaCelulaNaLinhaDaTabela(formatacaoDaTabela));
            xwpfRun.setFontSize(this.definirTamanhoDaFonteDaCelulaNaLinhaDaTabela(formatacaoDaTabela).intValue());
            xwpfRun.setText(celulaDaLinha.getValorDaCelula());
        }
    }

    private String definirFonteDaCelulaNaLinhaDaTabela(Optional<FormatacaoDaTabela> formatacaoDaTabela) {
        return formatacaoDaTabela.isPresent() ? formatacaoDaTabela.get().getFonte() : FormatacaoDaTabela.getFontePadrao();
    }

    private Integer definirTamanhoDaFonteDaCelulaNaLinhaDaTabela(Optional<FormatacaoDaTabela> formatacaoDaTabela) {
        return formatacaoDaTabela.isPresent() ? formatacaoDaTabela.get().getTamanhoDaFonte() : FormatacaoDaTabela.getTamanhoDaFontePadrao();
    }
}

