/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class ReflectionUtils {
    public static Map<String, Object> getFieldsAndValues(Object object) {
        LinkedHashMap<String, Object> mapFieldNameAndValueObject = new LinkedHashMap<String, Object>();
        try {
            Class<?> objectClass = object.getClass();
            ReflectionUtils.mapearCamposDoObjeto(object, mapFieldNameAndValueObject, objectClass);
            ReflectionUtils.mapearSuperClass(object, mapFieldNameAndValueObject, object.getClass().getSuperclass());
        }
        catch (Exception excecao) {
            new RuntimeException(excecao);
        }
        return mapFieldNameAndValueObject;
    }

    private static void mapearSuperClass(Object object, Map<String, Object> mapFieldNameAndValueObject, Class<?> superclass) throws IllegalAccessException {
        if (superclass != null) {
            ReflectionUtils.mapearCamposDoObjeto(object, mapFieldNameAndValueObject, superclass);
            ReflectionUtils.mapearSuperClass(object, mapFieldNameAndValueObject, superclass.getSuperclass());
        }
    }

    private static void mapearCamposDoObjeto(Object object, Map<String, Object> mapFieldNameAndValueObject, Class<? extends Object> objectClass) throws IllegalAccessException {
        for (Field field : objectClass.getDeclaredFields()) {
            field.setAccessible(true);
            mapFieldNameAndValueObject.put(field.getName(), field.get(object));
        }
    }
}

