/*
 * Decompiled with CFR 0.152.
 */
package editor.docx.cabecalho;

import editor.docx.paragrafo.EditorDeParagrafo;
import editor.docx.tabela.EditorDeTabela;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;

public class EditorDeCabecalho {
    private final EditorDeParagrafo editorDeParagrafo;
    private final EditorDeTabela editorDeTabela;

    private EditorDeCabecalho(EditorDeParagrafo editorDeParagrafo, EditorDeTabela editorDeTabela) {
        this.editorDeParagrafo = editorDeParagrafo;
        this.editorDeTabela = editorDeTabela;
    }

    public static EditorDeCabecalho comEditorDeParagrafoETabela(EditorDeParagrafo editorDeParagrafo, EditorDeTabela editorDeTabela) {
        return new EditorDeCabecalho(editorDeParagrafo, editorDeTabela);
    }

    public void editarConteudoDosCabecalhosDoDocumento(List<XWPFHeader> cabecalhos) {
        cabecalhos.forEach(cabecalhoDoDocumento -> this.editarCabecalho((XWPFHeader)cabecalhoDoDocumento));
    }

    private void editarCabecalho(XWPFHeader cabecalhoDoDocumento) {
        this.editorDeTabela.editarConteudoDasTabelas(cabecalhoDoDocumento.getTables());
        if (cabecalhoDoDocumento.getListParagraph() != null) {
            cabecalhoDoDocumento.getListParagraph().forEach(paragrafoDoCabecalho -> this.editorDeParagrafo.editarParagrafosDoDocumento((XWPFParagraph)paragrafoDoCabecalho));
        }
    }
}

