/*
 * Decompiled with CFR 0.152.
 */
package editor.docx.rodape;

import editor.docx.paragrafo.EditorDeParagrafo;
import editor.docx.tabela.EditorDeTabela;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;

public class EditorDeRodape {
    private final EditorDeParagrafo editorDeParagrafo;
    private final EditorDeTabela editorDeTabela;

    private EditorDeRodape(EditorDeParagrafo editorDeParagrafo, EditorDeTabela editorDeTabela) {
        this.editorDeParagrafo = editorDeParagrafo;
        this.editorDeTabela = editorDeTabela;
    }

    public static EditorDeRodape comEditorDeParagrafoETabela(EditorDeParagrafo editorDeParagrafo, EditorDeTabela editorDeTabela) {
        return new EditorDeRodape(editorDeParagrafo, editorDeTabela);
    }

    public EditorDeRodape editarConteudoDosRodapesDoDocumento(List<XWPFFooter> rodapesDoDocumento) {
        rodapesDoDocumento.forEach(rodapeDoDocumento -> this.editarRodape((XWPFFooter)rodapeDoDocumento));
        return this;
    }

    private void editarRodape(XWPFFooter rodape) {
        this.editarConteudoDasTabelasDoRodape(rodape.getTables());
        if (rodape.getListParagraph() != null) {
            rodape.getListParagraph().forEach(paragrafo -> this.editarParagrafo((XWPFParagraph)paragrafo));
        }
    }

    private void editarConteudoDasTabelasDoRodape(List<XWPFTable> tabelasDoRodape) {
        if (tabelasDoRodape != null) {
            this.editorDeTabela.editarConteudoDasTabelas(tabelasDoRodape);
        }
    }

    private void editarParagrafo(XWPFParagraph paragrafo) {
        this.editorDeParagrafo.editarParagrafosDoDocumento(paragrafo);
    }
}

