/*
 * Decompiled with CFR 0.152.
 */
package editor.docx.tabela;

import editor.docx.paragrafo.EditorDeParagrafo;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class EditorDeTabela {
    private final EditorDeParagrafo editorDeParagrafo;

    private EditorDeTabela(EditorDeParagrafo editorDeParagrafo) {
        this.editorDeParagrafo = editorDeParagrafo;
    }

    public static EditorDeTabela comEditorDeParagrafo(EditorDeParagrafo editorDeParagrafo) {
        return new EditorDeTabela(editorDeParagrafo);
    }

    public EditorDeTabela editarConteudoDasTabelas(List<XWPFTable> tabelas) {
        if (tabelas != null) {
            tabelas.forEach(tabela -> this.editarTabela((XWPFTable)tabela));
        }
        return this;
    }

    private void editarTabela(XWPFTable tabela) {
        if (tabela.getRows() != null) {
            tabela.getRows().forEach(linhaDaTabela -> this.editarLinhaDaTabela((XWPFTableRow)linhaDaTabela));
        }
    }

    private void editarLinhaDaTabela(XWPFTableRow linhaDaTabela) {
        if (linhaDaTabela.getTableCells() != null) {
            linhaDaTabela.getTableCells().forEach(celulaDaLinhaDaTabela -> this.editarCelulaDaLinhaDaTabela((XWPFTableCell)celulaDaLinhaDaTabela));
        }
    }

    private void editarCelulaDaLinhaDaTabela(XWPFTableCell celulaDaLinhaDaTabela) {
        celulaDaLinhaDaTabela.getParagraphs().forEach(paragrafo -> this.editarParagrafo((XWPFParagraph)paragrafo));
        if (celulaDaLinhaDaTabela.getTables() != null) {
            celulaDaLinhaDaTabela.getTables().forEach(tabela -> this.editarTabela((XWPFTable)tabela));
        }
    }

    private void editarParagrafo(XWPFParagraph paragrafo) {
        this.editorDeParagrafo.editarParagrafosDoDocumento(paragrafo);
    }
}

