/*
 * Decompiled with CFR 0.152.
 */
package editor.docx;

import editor.EditorDeArquivoDeTexto;
import editor.docx.ErroAoEditarArquivoDeTexto;
import editor.docx.cabecalho.EditorDeCabecalho;
import editor.docx.paragrafo.EditorDeParagrafo;
import editor.docx.rodape.EditorDeRodape;
import editor.docx.tabela.AdicionaLinhaNaTabelaDoDocumentoDeTexto;
import editor.docx.tabela.EditorDeTabela;
import editor.docx.tabela.FormatacaoDaTabela;
import editor.docx.tabela.MontadorDeTabelas;
import editor.docx.tabela.Tabela;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import utils.ReflectionUtils;

public class EditorDeArquivoDeTextoDocx
extends EditorDeArquivoDeTexto {
    private static final String EXTENSAO_DO_ARQUIVO = ".docx";
    private File arquivoEditado;
    private EditorDeParagrafo editorDeParagrafo;
    private EditorDeTabela editorDeTabela;
    private EditorDeRodape editorDeRodape;
    private EditorDeCabecalho editorDeCabecalho;
    private AdicionaLinhaNaTabelaDoDocumentoDeTexto adicionaLinhaNaTabelaDoDocumentoDeTexto;

    @Override
    public EditorDeArquivoDeTexto docxComTabelas(Object[] dadosParaMontarAsTabelasDoDocumento, FormatacaoDaTabela ... formatacaoDaTabelas) {
        if (dadosParaMontarAsTabelasDoDocumento != null) {
            List<Tabela> tabelasParaDocumentoDeTextos = MontadorDeTabelas.montar(dadosParaMontarAsTabelasDoDocumento);
            this.adicionaLinhaNaTabelaDoDocumentoDeTexto = AdicionaLinhaNaTabelaDoDocumentoDeTexto.comTabelas(tabelasParaDocumentoDeTextos, formatacaoDaTabelas);
        }
        return this;
    }

    @Override
    public EditorDeArquivoDeTexto docxComTabelas(List<Map<String, Object>> dadosParaMontarAsTabelasDoDocumento, FormatacaoDaTabela ... formatacaoDaTabelas) {
        if (dadosParaMontarAsTabelasDoDocumento != null) {
            Tabela tabelasParaDocumentoDeTextos = MontadorDeTabelas.montarTabela(dadosParaMontarAsTabelasDoDocumento);
            this.adicionaLinhaNaTabelaDoDocumentoDeTexto = AdicionaLinhaNaTabelaDoDocumentoDeTexto.comTabelas(tabelasParaDocumentoDeTextos, formatacaoDaTabelas);
        }
        return this;
    }

    @Override
    protected void editarArquivo(File arquivoQueSeraEditado, Object object, String nomeDoArquivoDeSaida) throws ErroAoEditarArquivoDeTexto {
        try {
            this.arquivoEditado = new File(nomeDoArquivoDeSaida + EXTENSAO_DO_ARQUIVO);
            this.instanciarEditores(object);
            XWPFDocument arquivoEditado = this.editarDocumento(arquivoQueSeraEditado);
            this.salvarNovoArquivo(arquivoEditado);
        }
        catch (Exception exception) {
            throw new ErroAoEditarArquivoDeTexto(exception);
        }
    }

    @Override
    protected OutputStream editarArquivo(InputStream arquivoQueSeraEditado, Object dados) throws ErroAoEditarArquivoDeTexto {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.instanciarEditores(dados);
            XWPFDocument documentoDoWordEditadoNoApachePoi = this.editarDocumento(arquivoQueSeraEditado);
            documentoDoWordEditadoNoApachePoi.write((OutputStream)outputStream);
        }
        catch (Exception exception) {
            throw new ErroAoEditarArquivoDeTexto(exception);
        }
        return outputStream;
    }

    @Override
    protected ByteBuffer editarArquivo(ByteBuffer arquivoQueSeraEditado, Object dados) throws ErroAoEditarArquivoDeTexto {
        ByteBuffer arquivoEditado;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(arquivoQueSeraEditado.array());
            OutputStream outputStream = this.editarArquivo(inputStream, dados);
            arquivoEditado = ByteBuffer.wrap(((ByteArrayOutputStream)outputStream).toByteArray());
            outputStream.close();
            ((InputStream)inputStream).close();
        }
        catch (Exception exception) {
            throw new ErroAoEditarArquivoDeTexto(exception);
        }
        return arquivoEditado;
    }

    @Override
    protected ByteBuffer editarArquivo(ByteBuffer arquivoQueSeraEditado, Map<String, Object> dados) throws ErroAoEditarArquivoDeTexto {
        ByteBuffer arquivoEditado;
        try {
            this.instanciarEditores(dados);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(arquivoQueSeraEditado.array());
            XWPFDocument documentoDoWordEditadoNoApachePoi = this.editarDocumento(inputStream);
            documentoDoWordEditadoNoApachePoi.write((OutputStream)outputStream);
            arquivoEditado = ByteBuffer.wrap(outputStream.toByteArray());
            ((OutputStream)outputStream).close();
            ((InputStream)inputStream).close();
        }
        catch (Exception exception) {
            throw new ErroAoEditarArquivoDeTexto(exception);
        }
        return arquivoEditado;
    }

    private void instanciarEditores(Map<String, Object> dados) {
        this.editorDeParagrafo = EditorDeParagrafo.comMapaDeAtributos(dados);
        this.editorDeTabela = EditorDeTabela.comEditorDeParagrafo(this.editorDeParagrafo);
        this.editorDeRodape = EditorDeRodape.comEditorDeParagrafoETabela(this.editorDeParagrafo, this.editorDeTabela);
        this.editorDeCabecalho = EditorDeCabecalho.comEditorDeParagrafoETabela(this.editorDeParagrafo, this.editorDeTabela);
    }

    @Override
    protected File getArquivoEditado() {
        return this.arquivoEditado;
    }

    private void salvarNovoArquivo(XWPFDocument documentoDocx) throws IOException {
        documentoDocx.write((OutputStream)new FileOutputStream(this.arquivoEditado));
    }

    private void instanciarEditores(Object object) {
        this.editorDeParagrafo = EditorDeParagrafo.comMapaDeAtributos(ReflectionUtils.getFieldsAndValues(object));
        this.editorDeTabela = EditorDeTabela.comEditorDeParagrafo(this.editorDeParagrafo);
        this.editorDeRodape = EditorDeRodape.comEditorDeParagrafoETabela(this.editorDeParagrafo, this.editorDeTabela);
        this.editorDeCabecalho = EditorDeCabecalho.comEditorDeParagrafoETabela(this.editorDeParagrafo, this.editorDeTabela);
    }

    private XWPFDocument editarDocumento(File arquivoQueSeraEditado) throws InvalidFormatException, IOException {
        XWPFDocument documentoDocx = new XWPFDocument(OPCPackage.open((File)arquivoQueSeraEditado));
        return this.editarDocumento(documentoDocx);
    }

    private XWPFDocument editarDocumento(InputStream arquivoQueSeraEditado) throws InvalidFormatException, IOException {
        XWPFDocument documentoDocx = new XWPFDocument(arquivoQueSeraEditado);
        return this.editarDocumento(documentoDocx);
    }

    private XWPFDocument editarDocumento(XWPFDocument documentoDocx) throws InvalidFormatException, IOException {
        this.editorDeCabecalho.editarConteudoDosCabecalhosDoDocumento(documentoDocx.getHeaderList());
        this.editorDeParagrafo.editarParagrafosDoDocumento(documentoDocx.getParagraphs());
        this.editorDeTabela.editarConteudoDasTabelas(documentoDocx.getTables());
        this.adicionarConteudoNasTabelasDoDocumentoDeTexto(documentoDocx);
        this.editorDeRodape.editarConteudoDosRodapesDoDocumento(documentoDocx.getFooterList());
        return documentoDocx;
    }

    private void adicionarConteudoNasTabelasDoDocumentoDeTexto(XWPFDocument documentoDocx) {
        if (this.adicionaLinhaNaTabelaDoDocumentoDeTexto != null) {
            this.adicionaLinhaNaTabelaDoDocumentoDeTexto.adicionarConteudoNasTabelasDoDocumentoDeTexto(documentoDocx.getTables());
        }
    }
}

