/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicyBase;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.aws.AmazonS3Client;
import ch.qos.logback.core.rolling.shutdown.RollingPolicyShutdownListener;
import ch.qos.logback.core.rolling.shutdown.ShutdownHookType;
import ch.qos.logback.core.rolling.shutdown.ShutdownHookUtil;
import java.io.File;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class S3TimeBasedRollingPolicy<E>
extends TimeBasedRollingPolicy<E>
implements RollingPolicyShutdownListener {
    private String awsAccessKey;
    private String awsSecretKey;
    private String s3BucketName;
    private String s3FolderName;
    private ShutdownHookType shutdownHookType;
    private boolean rolloverOnExit;
    private boolean prefixTimestamp;
    private boolean prefixIdentifier;
    private AmazonS3Client s3Client;
    private ExecutorService executor;
    private Date lastPeriod;

    public S3TimeBasedRollingPolicy() {
        this.setAwsAccessKey(null);
        this.setAwsSecretKey(null);
        this.setS3FolderName(null);
        this.setS3BucketName(null);
        this.setRolloverOnExit(false);
        this.setPrefixTimestamp(false);
        this.setPrefixIdentifier(false);
        this.setShutdownHookType(ShutdownHookType.NONE);
        this.lastPeriod = new Date();
        this.executor = Executors.newFixedThreadPool(1);
    }

    public void start() {
        super.start();
        this.lastPeriod = this.getLastPeriod();
        this.s3Client = new AmazonS3Client(this.getAwsAccessKey(), this.getAwsSecretKey(), this.getS3BucketName(), this.getS3FolderName(), this.isPrefixTimestamp(), this.isPrefixIdentifier());
        if (this.isPrefixIdentifier()) {
            this.addInfo("Using identifier prefix \"" + this.s3Client.getIdentifier() + "\"");
        }
        ShutdownHookUtil.registerShutdownHook(this, this.getShutdownHookType());
    }

    public void rollover() throws RolloverFailure {
        if (this.timeBasedFileNamingAndTriggeringPolicy.getElapsedPeriodsFileName() != null) {
            String elapsedPeriodsFileName = String.format("%s%s", this.timeBasedFileNamingAndTriggeringPolicy.getElapsedPeriodsFileName(), this.getFileNameSuffix());
            super.rollover();
            this.executor.execute(new UploadQueuer(elapsedPeriodsFileName, this.lastPeriod));
        } else {
            this.s3Client.uploadFileToS3Async(this.getActiveFileName(), this.lastPeriod, true);
        }
    }

    public Date getLastPeriod() {
        File file;
        Date lastPeriod = ((TimeBasedFileNamingAndTriggeringPolicyBase)this.timeBasedFileNamingAndTriggeringPolicy).dateInCurrentPeriod;
        if (this.getParentsRawFileProperty() != null && (file = new File(this.getParentsRawFileProperty())).exists() && file.canRead()) {
            lastPeriod = new Date(file.lastModified());
        }
        return lastPeriod;
    }

    @Override
    public void doShutdown() {
        if (this.isRolloverOnExit()) {
            this.rollover();
        } else {
            this.s3Client.uploadFileToS3Async(this.getActiveFileName(), this.lastPeriod, true);
        }
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
        this.s3Client.doShutdown();
    }

    private void waitForAsynchronousJobToStop(Future<?> aFuture, String jobDescription) {
        if (aFuture != null) {
            try {
                aFuture.get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                this.addError("Timeout while waiting for " + jobDescription + " job to finish", e);
            }
            catch (Exception e) {
                this.addError("Unexpected exception while waiting for " + jobDescription + " job to finish", e);
            }
        }
        this.lastPeriod = this.getLastPeriod();
    }

    private String getFileNameSuffix() {
        switch (this.compressionMode) {
            case GZ: {
                return ".gz";
            }
            case ZIP: {
                return ".zip";
            }
        }
        return "";
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    public String getS3FolderName() {
        return this.s3FolderName;
    }

    public void setS3FolderName(String s3FolderName) {
        this.s3FolderName = s3FolderName;
    }

    public boolean isRolloverOnExit() {
        return this.rolloverOnExit;
    }

    public void setRolloverOnExit(boolean rolloverOnExit) {
        this.rolloverOnExit = rolloverOnExit;
    }

    public ShutdownHookType getShutdownHookType() {
        return this.shutdownHookType;
    }

    public void setShutdownHookType(ShutdownHookType shutdownHookType) {
        this.shutdownHookType = shutdownHookType;
    }

    public boolean isPrefixTimestamp() {
        return this.prefixTimestamp;
    }

    public void setPrefixTimestamp(boolean prefixTimestamp) {
        this.prefixTimestamp = prefixTimestamp;
    }

    public boolean isPrefixIdentifier() {
        return this.prefixIdentifier;
    }

    public void setPrefixIdentifier(boolean prefixIdentifier) {
        this.prefixIdentifier = prefixIdentifier;
    }

    class UploadQueuer
    implements Runnable {
        private final String elapsedPeriodsFileName;
        private final Date date;

        public UploadQueuer(String elapsedPeriodsFileName, Date date) {
            this.elapsedPeriodsFileName = elapsedPeriodsFileName;
            this.date = date;
        }

        @Override
        public void run() {
            try {
                S3TimeBasedRollingPolicy.this.waitForAsynchronousJobToStop(S3TimeBasedRollingPolicy.this.compressionFuture, "compression");
                S3TimeBasedRollingPolicy.this.waitForAsynchronousJobToStop(S3TimeBasedRollingPolicy.this.cleanUpFuture, "clean-up");
                S3TimeBasedRollingPolicy.this.s3Client.uploadFileToS3Async(this.elapsedPeriodsFileName, this.date);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

