/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.aws.AmazonS3Client;
import ch.qos.logback.core.rolling.shutdown.RollingPolicyShutdownListener;
import ch.qos.logback.core.rolling.shutdown.ShutdownHookType;
import ch.qos.logback.core.rolling.shutdown.ShutdownHookUtil;
import java.util.Date;

public class S3FixedWindowRollingPolicy
extends FixedWindowRollingPolicy
implements RollingPolicyShutdownListener {
    private String awsAccessKey;
    private String awsSecretKey;
    private String s3BucketName;
    private String s3FolderName;
    private ShutdownHookType shutdownHookType;
    private boolean rolloverOnExit;
    private boolean prefixTimestamp;
    private boolean prefixIdentifier;
    private AmazonS3Client s3Client;

    public S3FixedWindowRollingPolicy() {
        this.setAwsAccessKey(null);
        this.setAwsSecretKey(null);
        this.setS3FolderName(null);
        this.setS3BucketName(null);
        this.setRolloverOnExit(false);
        this.setPrefixTimestamp(false);
        this.setPrefixIdentifier(false);
        this.setShutdownHookType(ShutdownHookType.NONE);
    }

    public void start() {
        super.start();
        this.s3Client = new AmazonS3Client(this.getAwsAccessKey(), this.getAwsSecretKey(), this.getS3BucketName(), this.getS3FolderName(), this.isPrefixTimestamp(), this.isPrefixIdentifier());
        if (this.isPrefixIdentifier()) {
            this.addInfo("Using identifier prefix \"" + this.s3Client.getIdentifier() + "\"");
        }
        ShutdownHookUtil.registerShutdownHook(this, this.getShutdownHookType());
    }

    public void rollover() throws RolloverFailure {
        super.rollover();
        this.s3Client.uploadFileToS3Async(this.fileNamePattern.convertInt(this.getMinIndex()), new Date());
    }

    @Override
    public void doShutdown() {
        if (this.isRolloverOnExit()) {
            this.rollover();
        } else {
            this.s3Client.uploadFileToS3Async(this.getActiveFileName(), new Date(), true);
        }
        this.s3Client.doShutdown();
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public void setS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
    }

    public String getS3FolderName() {
        return this.s3FolderName;
    }

    public void setS3FolderName(String s3FolderName) {
        this.s3FolderName = s3FolderName;
    }

    public boolean isRolloverOnExit() {
        return this.rolloverOnExit;
    }

    public void setRolloverOnExit(boolean rolloverOnExit) {
        this.rolloverOnExit = rolloverOnExit;
    }

    public ShutdownHookType getShutdownHookType() {
        return this.shutdownHookType;
    }

    public void setShutdownHookType(ShutdownHookType shutdownHookType) {
        this.shutdownHookType = shutdownHookType;
    }

    public boolean isPrefixTimestamp() {
        return this.prefixTimestamp;
    }

    public void setPrefixTimestamp(boolean prefixTimestamp) {
        this.prefixTimestamp = prefixTimestamp;
    }

    public boolean isPrefixIdentifier() {
        return this.prefixIdentifier;
    }

    public void setPrefixIdentifier(boolean prefixIdentifier) {
        this.prefixIdentifier = prefixIdentifier;
    }
}

