/*
 * Decompiled with CFR 0.152.
 */
package br.com.damsete.arq.validations;

import br.com.damsete.arq.notifications.Notifiable;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class FluentValidation
extends Notifiable {
    public FluentValidation isTrue(boolean value, String code, Object ... args) {
        if (!value) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isFalse(boolean value, String code, Object ... args) {
        if (value) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNull(Object value, String code, Object ... args) {
        if (value != null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNotNull(Object value, String code, Object ... args) {
        if (value == null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNull(String value, String code, Object ... args) {
        if (value != null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNotNull(String value, String code, Object ... args) {
        if (value == null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isEmpty(String value, String code, Object ... args) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNotEmpty(String value, String code, Object ... args) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation areEquals(String value, String text, String code, Object ... args) {
        if (!value.equalsIgnoreCase(text)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation areNotEquals(String value, String text, String code, Object ... args) {
        if (value.equalsIgnoreCase(text)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation hasMinLen(String value, int min, String code, Object ... args) {
        if (value == null) {
            value = "";
        }
        if (value.length() < min) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation hasMaxLen(String value, int max, String code, Object ... args) {
        if (value == null) {
            value = "";
        }
        if (value.length() > max) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation hasLen(String value, int len, String code, Object ... args) {
        if (value == null) {
            value = "";
        }
        if (value.length() != len) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation contains(String value, String text, String code, Object ... args) {
        if (value == null) {
            value = "";
        }
        if (!value.contains(text)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isEmail(String value, String code, Object ... args) {
        Pattern pattern;
        Matcher matcher;
        if (value == null) {
            value = "";
        }
        if (!(matcher = (pattern = Pattern.compile("^(.+)@(.+)$")).matcher(value)).matches()) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isUsername(String value, String code, Object ... args) {
        Pattern pattern;
        Matcher matcher;
        if (value == null) {
            value = "";
        }
        if (!(matcher = (pattern = Pattern.compile("^([a-zA-Z])+([\\w]{2,})+$")).matcher(value)).matches()) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNull(Long value, String code, Object ... args) {
        if (value != null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNotNull(Long value, String code, Object ... args) {
        if (value == null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isGreaterThan(Long value, Long comparer, String code, Object ... args) {
        if (value == null) {
            value = 0L;
        }
        if (value <= comparer) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isGreaterOrEqualsThan(Long value, Long comparer, String code, Object ... args) {
        if (value == null) {
            value = 0L;
        }
        if (value < comparer) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isLowerThan(Long value, Long comparer, String code, Object ... args) {
        if (value == null) {
            value = 0L;
        }
        if (value >= comparer) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isLowerOrEqualsThan(Long value, Long comparer, String code, Object ... args) {
        if (value == null) {
            value = 0L;
        }
        if (value > comparer) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation areEquals(Long value, Long comparer, String code, Object ... args) {
        if (value == null) {
            value = 0L;
        }
        if (!value.equals(comparer)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation areNotEquals(Long value, Long comparer, String code, Object ... args) {
        if (value == null) {
            value = 0L;
        }
        if (value.equals(comparer)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isBetween(Long value, Long from, Long to, String code, Object ... args) {
        if (value == null) {
            value = 0L;
        }
        if (value <= from || value >= to) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNull(Integer value, String code, Object ... args) {
        if (value != null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNotNull(Integer value, String code, Object ... args) {
        if (value == null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isGreaterThan(Integer value, Integer comparer, String code, Object ... args) {
        if (value == null) {
            value = 0;
        }
        if (value <= comparer) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isGreaterOrEqualsThan(Integer value, Integer comparer, String code, Object ... args) {
        if (value == null) {
            value = 0;
        }
        if (value < comparer) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isLowerThan(Integer value, Integer comparer, String code, Object ... args) {
        if (value == null) {
            value = 0;
        }
        if (value >= comparer) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isLowerOrEqualsThan(Integer value, Integer comparer, String code, Object ... args) {
        if (value == null) {
            value = 0;
        }
        if (value > comparer) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation areEquals(Integer value, Integer comparer, String code, Object ... args) {
        if (value == null) {
            value = 0;
        }
        if (!value.equals(comparer)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation areNotEquals(Integer value, Integer comparer, String code, Object ... args) {
        if (value == null) {
            value = 0;
        }
        if (value.equals(comparer)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isBetween(Integer value, Integer from, Integer to, String code, Object ... args) {
        if (value == null) {
            value = 0;
        }
        if (value <= from || value >= to) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNull(Float value, String code, Object ... args) {
        if (value != null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNotNull(Float value, String code, Object ... args) {
        if (value == null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isGreaterThan(Float value, Float comparer, String code, Object ... args) {
        if (value == null) {
            value = Float.valueOf(0.0f);
        }
        if (value.floatValue() <= comparer.floatValue()) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isGreaterOrEqualsThan(Float value, Float comparer, String code, Object ... args) {
        if (value == null) {
            value = Float.valueOf(0.0f);
        }
        if (value.floatValue() < comparer.floatValue()) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isLowerThan(Float value, Float comparer, String code, Object ... args) {
        if (value == null) {
            value = Float.valueOf(0.0f);
        }
        if (value.floatValue() >= comparer.floatValue()) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isLowerOrEqualsThan(Float value, Float comparer, String code, Object ... args) {
        if (value == null) {
            value = Float.valueOf(0.0f);
        }
        if (value.floatValue() > comparer.floatValue()) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation areEquals(Float value, Float comparer, String code, Object ... args) {
        if (value == null) {
            value = Float.valueOf(0.0f);
        }
        if (!value.equals(comparer)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation areNotEquals(Float value, Float comparer, String code, Object ... args) {
        if (value == null) {
            value = Float.valueOf(0.0f);
        }
        if (value.equals(comparer)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isBetween(Float value, Float from, Float to, String code, Object ... args) {
        if (value == null) {
            value = Float.valueOf(0.0f);
        }
        if (!(value.floatValue() > from.floatValue()) || !(value.floatValue() < to.floatValue())) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNull(Double value, String code, Object ... args) {
        if (value != null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNotNull(Double value, String code, Object ... args) {
        if (value == null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isGreaterThan(Double value, Double comparer, String code, Object ... args) {
        if (value <= comparer) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isGreaterOrEqualsThan(Double value, Double comparer, String code, Object ... args) {
        if (value < comparer) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isLowerThan(Double value, Double comparer, String code, Object ... args) {
        if (value >= comparer) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isLowerOrEqualsThan(Double value, Double comparer, String code, Object ... args) {
        if (value > comparer) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation areEquals(Double value, Double comparer, String code, Object ... args) {
        if (!value.equals(comparer)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation areNotEquals(Double value, Double comparer, String code, Object ... args) {
        if (value.equals(comparer)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isBetween(Double value, Double from, Double to, String code, Object ... args) {
        if (!(value > from) || !(value < to)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNull(BigDecimal value, String code, Object ... args) {
        if (value != null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isNotNull(BigDecimal value, String code, Object ... args) {
        if (value == null) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isGreaterThan(BigDecimal value, BigDecimal comparer, String code, Object ... args) {
        if (value.compareTo(comparer) <= 0) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isGreaterOrEqualsThan(BigDecimal value, BigDecimal comparer, String code, Object ... args) {
        if (value.compareTo(comparer) < 0) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isLowerThan(BigDecimal value, BigDecimal comparer, String code, Object ... args) {
        if (value.compareTo(comparer) >= 0) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isLowerOrEqualsThan(BigDecimal value, BigDecimal comparer, String code, Object ... args) {
        if (value.compareTo(comparer) > 0) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation areEquals(BigDecimal value, BigDecimal comparer, String code, Object ... args) {
        if (!value.equals(comparer)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation areNotEquals(BigDecimal value, BigDecimal comparer, String code, Object ... args) {
        if (value.equals(comparer)) {
            this.addNotification(code, args);
        }
        return this;
    }

    public FluentValidation isBetween(BigDecimal value, BigDecimal from, BigDecimal to, String code, Object ... args) {
        if (value.compareTo(from) >= 0 || value.compareTo(to) <= 0) {
            this.addNotification(code, args);
        }
        return this;
    }
}

