/*
 * Decompiled with CFR 0.152.
 */
package br.com.damsete.arq.types;

import br.com.damsete.arq.types.Type;
import org.apache.commons.lang3.StringUtils;

public class ZipCode
implements Type<Long> {
    private static final long serialVersionUID = 1L;
    private Long zipCode;

    public ZipCode(Long zipCode) {
        this.zipCode = zipCode;
    }

    public String toString() {
        return this.format();
    }

    @Override
    public Long getRawValue() {
        return this.zipCode;
    }

    public String format() {
        if (this.zipCode == null) {
            return null;
        }
        String zipCodePadded = StringUtils.leftPad((String)this.zipCode.toString(), (int)8, (char)'0');
        return String.format("%s-%s", zipCodePadded.substring(0, 5), zipCodePadded.substring(5, 8));
    }

    public String unformat() {
        if (this.zipCode == null) {
            return null;
        }
        return this.format().replace("-", "");
    }
}

